package com.ociweb.jnb.oct2009;

import org.apache.commons.lang.enums.Enum;

import java.util.List;


public class EnumExample1 {
    // Plus and Minus enum written with Java's enum
    public enum JavaOperator {
        PLUS {
            @Override
            public int calculate(int operand1, int operand2) {
                return operand1 + operand2;
            }
        },
        MINUS {
            @Override
            public int calculate(int operand1, int operand2) {
                return operand1 - operand2;
            }
        };

        public abstract int calculate(int operand1, int operand2);
    }

    // Plus and Minus enum written with Commons' Enum
    public static abstract class CommonsOperator extends Enum {
        public static final CommonsOperator PLUS = new CommonsOperator("Plus") {
            @Override
            public int calculate(int operand1, int operand2) {
                return operand1 + operand2;
            }
        };

        public static final CommonsOperator MINUS = new CommonsOperator(
                "Minus") {
            @Override
            public int calculate(int operand1, int operand2) {
                return operand1 + operand2;
            }
        };

        private CommonsOperator(String name) {
            super(name);
        }

        public abstract int calculate(int operand1, int operand2);

        @Override
        public Class getEnumClass() {
            // this method is needed because the class has an abstract method
            return CommonsOperator.class;
        }

        public static List getEnumList() {
          return getEnumList(CommonsOperator.class);
        }
    }
}
