package com.ociweb.jnb.oct2009;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;


public class BuilderExample4 {
    private final int id;
    private final String[] names;
    private final ToStringStyle toStringStyle;

    public BuilderExample4(int id, String[] names,
                           ToStringStyle toStringStyle) {
        this.id = id;
        this.names = names;
        this.toStringStyle = toStringStyle;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this, toStringStyle).append(id).append(
                "names", names).toString();
    }

    public static void main(String[] args) {
        final String[] array = {"a", "b"};
        System.out.println("DEFAULT_STYLE: " +
                new BuilderExample4(1, array, ToStringStyle.DEFAULT_STYLE));
        System.out.println("MULTI_LINE_STYLE: " +
                new BuilderExample4(2, array, ToStringStyle.MULTI_LINE_STYLE));
        System.out.println("NO_FIELD_NAMES_STYLE: " +
                new BuilderExample4(3, array, ToStringStyle.NO_FIELD_NAMES_STYLE));
        System.out.println("SHORT_PREFIX_STYLE: " +
                new BuilderExample4(4, array, ToStringStyle.SHORT_PREFIX_STYLE));
        System.out.println("SIMPLE_STYLE: " +
                new BuilderExample4(5, array, ToStringStyle.SIMPLE_STYLE));
    }
}
