package com.ociweb.jnb.oct2009;

import org.apache.commons.lang.enums.Enum;


public class EnumExample2 {

    public static abstract class AbstractVehicle extends Enum {
        private double topSpeed;

        protected AbstractVehicle(String name, double topSpeed) {
            super(name);
            this.topSpeed = topSpeed;
        }

        public double getTopSpeed() {
            return topSpeed;
        }
    }

    public static class Car extends AbstractVehicle {
        public static final Car FORD_MODEL_T = new Car("Model T", 45.0);
        public static final Car TESLA_ROADSTER = new Car("Roadster", 125.0);

        private Car(String name, double speed) {
            super(name, speed);
        }

    }

    public static class Plane extends AbstractVehicle {
        public static final Plane CESSNA_CITATION_X = new Plane("Citation X",
                703.0);
        public static final Plane BELL_X1 = new Plane("X-1", 957.0);

        private Plane(String name, double speed) {
            super(name, speed);
        }

    }
}
