package com.ociweb.jnb.oct2009;

import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.commons.lang.mutable.MutableDouble;

import java.util.Arrays;


public class MutableExample {
    private static Roots getSquareRootsObject(double value) {
        final double sqrt = Math.sqrt(value);
        final Roots roots = new Roots();
        roots.negative = -sqrt;
        roots.positive = sqrt;

        return roots;
    }

    private static void getSquareRootsArray(double value, double[] roots) {
        Validate.isTrue(roots.length == 2, "The output array must have size 2",
                roots.length);

        final double sqrt = Math.sqrt(value);
        roots[0] = -sqrt;
        roots[1] = sqrt;
    }

    private static void getSquareRootsArrays(double value, double[] positive,
                                             double[] negative) {
        Validate.isTrue(negative.length == 1,
                "The output array must have size 1", negative.length);
        Validate.isTrue(positive.length == 1,
                "The output array must have size 1", positive.length);

        final double sqrt = Math.sqrt(value);
        negative[0] = -sqrt;
        positive[0] = sqrt;
    }

    private static void getSquareRootsMutable(double value,
                                              MutableDouble negative,
                                              MutableDouble positive) {
        final double sqrt = Math.sqrt(value);
        negative.setValue(-sqrt);
        positive.setValue(sqrt);
    }

    public static void main(String[] args) {
        // using value object
        System.out.println("getSquareRootsObject(6.25) = " +
                getSquareRootsObject(6.25));
        System.out.println();

        // using one array
        final double[] roots = new double[2];
        getSquareRootsArray(6.25, roots);
        System.out.println("array roots = " + Arrays.toString(roots));
        System.out.println();

        // using multiple arrays
        final double[] negativeArray = new double[1];
        final double[] positiveArray = new double[1];
        getSquareRootsArrays(6.25, negativeArray, positiveArray);
        System.out.println("negativeArray = " + negativeArray[0]);
        System.out.println("positiveArray = " + positiveArray[0]);
        System.out.println();

        // using mutable objects
        final MutableDouble negativeMutable = new MutableDouble();
        final MutableDouble positiveMutable = new MutableDouble();
        getSquareRootsMutable(6.25, negativeMutable, positiveMutable);
        System.out.println("negativeMutable = " + negativeMutable);
        System.out.println("positiveMutable = " + positiveMutable);
        // demonstrate the doubleValue method
        System.out.println("negativeMutable = " +
                negativeMutable.doubleValue());
        System.out.println("positiveMutable = " +
                positiveMutable.doubleValue());
    }

    private static class Roots {
        private double negative;
        private double positive;

        @Override
        public String toString() {
            return ToStringBuilder.reflectionToString(this,
                    ToStringStyle.SIMPLE_STYLE);
        }
    }
}
