package com.ociweb.jnb.oct2009;

import org.apache.commons.lang.math.RandomUtils;
import org.apache.commons.lang.time.StopWatch;


public class TimeExample {
    public static void main(String[] args) throws InterruptedException {
        final StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        System.out.println("At the start");
        System.out.println("stopWatch.getStartTime() = " +
                stopWatch.getStartTime());
        System.out.println("stopWatch.getTime() = " + stopWatch.getTime());

        Thread.sleep(RandomUtils.nextInt(500));
        stopWatch.split();
        System.out.println("\nAfter split");
        System.out.println("stopWatch.getSplitTime() = " +
                stopWatch.getSplitTime());
        System.out.println("stopWatch.getTime() = " + stopWatch.getTime());

        int pause = RandomUtils.nextInt(500);
        Thread.sleep(pause);
        System.out.println("\nAfter " + pause +
                " ms delay, time continues but split doesn't");
        System.out.println("stopWatch.getSplitTime() = " +
                stopWatch.getSplitTime());
        System.out.println("stopWatch.getTime() = " + stopWatch.getTime());
        stopWatch.unsplit();

        Thread.sleep(RandomUtils.nextInt(500));
        stopWatch.suspend();
        System.out.println("\nAfter suspend");
        System.out.println("stopWatch.getTime() = " + stopWatch.getTime());
        pause = RandomUtils.nextInt(500);
        Thread.sleep(pause);
        stopWatch.resume();
        System.out.println("\nAfter " + pause + " ms delay, nothing changes");
        System.out.println("stopWatch.getTime() = " + stopWatch.getTime());

        Thread.sleep(RandomUtils.nextInt(500));
        stopWatch.stop();
        System.out.println("\nAfter stop");
        System.out.println("stopWatch.getTime() = " + stopWatch.getTime());
    }
}
