package com.ociweb.jnb;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.xml.XppDomDriver;

import junit.framework.TestCase;

public class AssemblyReadTest extends TestCase {

	private static final String EXPECTED_RESULTS_FILENAME = "expectedResults.xml";
	private static final String ACTUAL_RESULTS_FILENAME = "actualResults.xml";
	private XStream xstream = new XStream(new XppDomDriver());

	public void testReadXML() {
	    String inData = readFile(EXPECTED_RESULTS_FILENAME).trim();

	    Object obj = xstream.fromXML(inData);
	    assertNotNull(obj);
	    assertTrue(obj instanceof Assembly);
        if (obj instanceof Assembly) {
        	Assembly assembly = (Assembly)obj;
        	String xmlText = getAssemblyXML(assembly).trim();
	        System.out.print(xmlText);
	        if (!inData.equals(xmlText)) {
	            try {
	                PrintWriter out = new PrintWriter(new FileWriter(ACTUAL_RESULTS_FILENAME));
	                out.print(xmlText);
	                out.close();
	            }
	            catch (Exception e) {
	                System.out.println("writeTextFile error: " + e.getMessage());
	            }
	        }
	        assertEquals(inData, xmlText);
        }
	}

	public String getAssemblyXML(Assembly assembly)
    {
        StringBuffer buf = new StringBuffer();
        writeXMLHead(buf);
        buf.append(assembly.toXMLString());

        return buf.toString();
    }

	private void writeXMLHead(StringBuffer buf)
    {
        buf.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
    }

	protected void setUp() throws Exception {
		Assembly.setupXStream(xstream);
		super.setUp();
	}

	protected void tearDown() throws Exception {
		super.tearDown();
	}

    String readFile(String fileName) {
        StringBuffer buf = new StringBuffer();
        try {
            BufferedReader in = new BufferedReader(new FileReader(fileName));
            while (true) {
                String text = in.readLine();
                if (text == null)
                    break;
                buf.append(text + '\n');
            }
            in.close();
        } catch (Exception e) {
            System.out.println("read text file error: " + e.getMessage());
        }
        return buf.toString();
    }
}
