package com.ociweb.jnb;

import java.awt.geom.Arc2D;
import java.awt.geom.Area;

import com.thoughtworks.xstream.XStream;

public class GeneralCirc extends GeneralArea {

	private static final String XSREAM_ID_GENERAL_CIRC = "GeneralCirc";
	private static final String GENERAL_CIRC_VERSION = "generalCircVersion";

	private static final String GENERAL_CIRC_DIAMETER = "diameter";

	private static final double DEFAULT_DIAMETER = 1.0;

	// persisted data.
	public double diameter = DEFAULT_DIAMETER;
	private int generalCircVersion = 1;

	public GeneralCirc() {
		super(DEFAULT_ORIGIN_X, DEFAULT_ORIGIN_Y);
		setDiameter(DEFAULT_DIAMETER);
	}

	public GeneralCirc(double originX, double originY, double diameter) {
		super(originX, originY);
		setDiameter(diameter);
	}

	protected void regenerate() {
		setArea(
			new Area(
				new Arc2D.Double(
						getOriginX(),
						getOriginY(),
						getDiameter(),
						getDiameter(),
						0,
						Math.PI * 2,
						Arc2D.Double.PIE
					)
			)
		);
	}

	public double getDiameter() {
		return diameter;
	}

	public void setDiameter(double diameter) {
		if (Math.abs(this.diameter - diameter) > AREA_EPSILON) {
			double oldDiameter= this.diameter;
			this.diameter = diameter;
			propertyChange(GENERAL_CIRC_DIAMETER, oldDiameter, diameter);
		}
	}

	public int getGeneralCircVersion() {
		return generalCircVersion;
	}

	public void setGeneralCircVersion(int generalCircVersion) {
		this.generalCircVersion = generalCircVersion;
	}

	public static void setupXStream(XStream xstream) {
		xstream.alias(XSREAM_ID_GENERAL_CIRC, GeneralCirc.class);
		xstream.useAttributeFor(GENERAL_CIRC_VERSION, int.class);
	}

}
