package com.ociweb.jnb;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;

import junit.framework.TestCase;


public class AssemblyWriteTest extends TestCase {

	private static final String ACTUAL_RESULTS_XML = "AssemblyWriteTest_actual.xml";
    private static final String EXPECTED_RESULTS_XML = "AssemblyWriteTest_expected.xml";

    Assembly assembly = null;

	protected void setUp() throws Exception {
		super.setUp();
	    assembly = new Assembly();
		assembly.add(new GeneralRect());
		assembly.add(new GeneralCirc());
	}

	protected void tearDown() throws Exception {
		super.tearDown();
	}

	public void testSaveToXStream() {
		String xmlString = getAssemblyXML(assembly);
		System.out.println(xmlString);
	    String inData = readFile(EXPECTED_RESULTS_XML);
	    if (inData.length() < 25) { // go to save expected mode ;)
	        try {
	            PrintWriter out = new PrintWriter(new FileWriter(EXPECTED_RESULTS_XML));
	            out.print(xmlString);
	            out.close();
	        }
	        catch (Exception e) {
	            System.out.println("writeTextFile error: " + e.getMessage());
	        }
	    }
	    else {
	        assertEquals(xmlString.trim(), inData.trim());
	        try {
	            PrintWriter out = new PrintWriter(new FileWriter(ACTUAL_RESULTS_XML));
	            out.print(xmlString);
	            out.close();
	        }
	        catch (Exception e) {
	            System.out.println("writeTextFile error: " + e.getMessage());
	        }
	    }
	}

	private void writeXMLHead(StringBuffer buf)
    {
        buf.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
    }

	public String getAssemblyXML(Assembly assembly)
    {
        StringBuffer buf = new StringBuffer();
        writeXMLHead(buf);
        buf.append(assembly.toXMLString());

        return buf.toString();
    }

    String readFile(String fileName) {
        StringBuffer buf = new StringBuffer();
        try {
            BufferedReader in = new BufferedReader(new FileReader(fileName));
            while (true) {
                String text = in.readLine();
                if (text == null)
                    break;
                buf.append(text + '\n');
            }
            in.close();
        } catch (Exception e) {
            System.out.println("read text file error: " + e.getMessage());
        }
        return buf.toString();
    }
}
