package com.ociweb.jnb;

import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;

import com.thoughtworks.xstream.XStream;

public class GeneralRect extends GeneralArea {

	private static final String XSREAM_ID_GENERAL_RECT = "GeneralRect";
	private static final String GENERAL_RECT_VERSION = "generalRectVersion";

	private static final String GENERAL_RECT_WIDTH = "width";
	private static final String GENERAL_RECT_HEIGHT = "height";

	private static final double DEFAULT_WIDTH = 2.0;
	private static final double DEFAULT_HEIGHT = 1.0;

	// persisted data.
	public double width = DEFAULT_WIDTH;
	public double height = DEFAULT_HEIGHT;
	private int generalRectVersion = 1;

	public GeneralRect() {
		super(DEFAULT_ORIGIN_X, DEFAULT_ORIGIN_Y);
		setWidth(DEFAULT_WIDTH);
		setHeight(DEFAULT_HEIGHT);
	}

	public GeneralRect(double originX, double originY, double width, double height) {
		super(originX, originY);
		setWidth(width);
		setHeight(height);
	}

	protected void regenerate() {
		setArea(new Area(new Rectangle2D.Double(getOriginX(), getOriginY(), getHeight(), getWidth())));
	}

	public double getWidth() {
		return width;
	}

	public void setWidth(double width) {
		if (Math.abs(this.width - width) > AREA_EPSILON) {
			double oldWidth = this.width;
			this.width = width;
			propertyChange(GENERAL_RECT_WIDTH, oldWidth, width);
		}
	}

	public double getHeight() {
		return height;
	}

	public void setHeight(double height) {
		this.height = height;
		if (Math.abs(this.height - height) > AREA_EPSILON) {
			double oldHeight = this.height;
			this.height = height;
			propertyChange(GENERAL_RECT_HEIGHT, oldHeight, height);
		}
	}

	public int getGeneralRectVersion() {
		return generalRectVersion;
	}

	public void setGeneralRectVersion(int generalRectVersion) {
		this.generalRectVersion = generalRectVersion;
	}

	public static void setupXStream(XStream xstream) {
		xstream.alias(XSREAM_ID_GENERAL_RECT, GeneralRect.class);
		xstream.useAttributeFor(GENERAL_RECT_VERSION, int.class);
	}

}
