﻿using System.Collections.Generic;

namespace DataSource
{
	public class UserData
	{

		public class UserInfo
		{
			public int ID;
			public string UserName;
			public string FirstName;
			public string LastName;
		}

		public static List<UserInfo> GetUsers()
		{
			var info = new List<UserInfo>
			{
				GetUser(1),
				GetUser(2),
				GetUser(3)
			};

			return info;
		}

		private static UserInfo GetUser(int id)
		{
			switch (id)
			{
				case 1:
					return new UserInfo
					{
						ID = 1,
						UserName = "ssmith",
						FirstName = "Sam",
						LastName = "Smith"
					};
				case 2:
					return new UserInfo
					{
						ID = 2,
						UserName = "bbrown",
						FirstName = "Bill",
						LastName = "Brown"
					};
				case 3:
					return new UserInfo
					{
						ID = 3,
						UserName = "aant",
						FirstName = "Adam",
						LastName = "Ant"
					};
			}

			return new UserInfo();
		}

		public class UserDetails
		{
			public int ID;
			public UserInfo Info;
			public string Address;
			public string City;
			public string State;
			public string PostalCode;
		}

		public static UserDetails GetUserDetails(string id)
		{
			var details = new UserDetails();

			int userId;
			if (int.TryParse(id, out userId))
			{
				switch (userId)
				{
					case 1:
						details.ID = 1;
						details.Info = GetUser(userId);
						details.Address = "123 N. Main";
						details.City = "NewTown";
						details.State = "IL";
						details.PostalCode = "63666";
						break;
					case 2:
						details.ID = 2;
						details.Info = GetUser(userId);
						details.Address = "6787 Spring St.";
						details.City = "Dallas";
						details.State = "TX";
						details.PostalCode = "85858";
						break;
					case 3:
						details.ID = 3;
						details.Info = GetUser(userId);
						details.Address = "12 W. Pine";
						details.City = "New York";
						details.State = "NY";
						details.PostalCode = "12123";
						break;
				}
			}

			return details;
		}
	}
}
