﻿using System;
using System.Collections.Generic;
using System.Web.Services;
using System.Web.Script.Services;
using DataSource;

public partial class AjaxGetHtml : System.Web.UI.Page
{
    [WebMethod]
    [ScriptMethod(UseHttpGet = true, ResponseFormat = ResponseFormat.Xml)]
    public static string GetUsers()
    {
        var sb = new System.Text.StringBuilder();
        sb.Append(@"<h3>Users</h3>");
        sb.Append(@"<table id=""tblUsers"" class=""users_table"">");
        sb.Append(@"<thead><tr>");
        sb.Append(@"<th style=""width:100px"">Username</th>");
        sb.Append(@"<th style=""width:100px"">Firstname</th>");
        sb.Append(@"<th style=""width:100px"">Lastname</th>");
        sb.Append(@"<th style=""visibility:hidden""></th>");
        sb.Append(@"</tr></thead>");
        
        var users = UserData.GetUsers();
        foreach (var user in users)
        {
            sb.Append(@"<tr><td>");
            sb.Append(user.UserName);
            sb.Append(@"</td><td>");
            sb.Append(user.FirstName);
            sb.Append(@"</td><td>");
            sb.Append(user.LastName);
            sb.Append(@"</td><td style=""visibility:hidden"">");
            sb.Append(user.ID);
            sb.Append(@"</td></tr>");
        }

        return sb.ToString();
    }

    [WebMethod]
    [ScriptMethod(UseHttpGet = true, ResponseFormat = ResponseFormat.Xml)]
    public static string GetUserDetails(string id)
    {
        var sb = new System.Text.StringBuilder();
        sb.Append(@"<h3>User Details</h3>");

        var userDetails = UserData.GetUserDetails(id);

        sb.Append(@"<table id=""tblUserDetails"" class=""user_details_table"">");
        sb.Append(@"<tbody>");
        sb.Append(@"<tr><td width=""100px"">Username:</td><td>");
        sb.Append(userDetails.Info.UserName);
        sb.Append(@"</td></tr><tr><td>First Name:</td><td>");
        sb.Append(userDetails.Info.FirstName);
        sb.Append(@"</td></tr><tr><td>Last Name:</td><td>");
        sb.Append(userDetails.Info.LastName);
        sb.Append(@"</td></tr><tr><td>Address:</td><td>");
        sb.Append(userDetails.Address);
        sb.Append(@"</td></tr><tr><td>City:</td><td>");
        sb.Append(userDetails.City);
        sb.Append(@"</td></tr><tr><td>State:</td><td>");
        sb.Append(userDetails.State);
        sb.Append(@"</td></tr><tr><td>Zip:</td><td>");
        sb.Append(userDetails.PostalCode);
        sb.Append(@"</td></tr></tbody>");
        sb.Append(@"</table>");

        return sb.ToString();
    }
}