$(document).ready(function () {
	// Gets a list of users and populates a Users table
	$("#btnLoadUsers").click(function () {
		$("#userDetails").hide();

		var req = $.ajax({
			type: "GET",
			url: "JQueryAjax.aspx/GetUsers",
			contentType: "application/json; charset=utf-8",
			dataType: "json",
			data: {}
		});

		req.done(function (data) {
			var table = $("#tblUsers tbody");
			table.html('');
			$("#userRowTemplate").tmpl(data.d).appendTo(table);
			if ($("#userTable").css("display") == "none") {
				$("#userTable").slideToggle();
			}
		});

		req.fail(function (xhr, status) { alert("FAILED: " + status); });
	});

	// Gets details for a user and populates a User Details table
	$("#tblUsers").delegate("tr", "click", function () {
		if (!this.rowIndex) return;
		var id = this.cells[3].innerHTML;

		var req = $.ajax({
			type: "GET",
			url: "JQueryAjax.aspx/GetUserDetails",
			contentType: "application/json; charset=utf-8",
			dataType: "json",
			data: "id=" + id
		});

		req.done(function (data) {
			if ($("#userDetails").css("display") == "none") {
				$("#userDetails").slideToggle();
			}
			$("#username").text(data.d.Info.UserName);
			$("#firstname").text(data.d.Info.FirstName);
			$("#lastname").text(data.d.Info.LastName);
			$("#address").text(data.d.Address);
			$("#city").text(data.d.City);
			$("#state").text(data.d.State);
			$("#zip").text(data.d.PostalCode);
		});

		req.fail(function (xhr, status) { alert("FAILED: " + status); });
	});
});
