$(document).ready(function () {
    // Gets a list of users and populates a Users table
    $("#btnLoadUsers").click(function () {
        $("#userDetailsContainer").hide();
        $("#tblUsers").undelegate();
        $("#userDetailsContainer").empty();
        $("#userTableContainer").empty();

        var req = $.ajax({
            type: "GET",
            url: "AjaxGetHtml.aspx/GetUsers",
            contentType: "application/json; charset=utf-8",
            dataType: "html",
            data: {}
        });

        req.done(function (data) {
            $("#userTableContainer").append(data);

            // Gets details for a user and populates a User Details table
            $("#tblUsers").delegate("tr", "click", function () {
                if (!this.rowIndex) return;
                var id = this.cells[3].innerHTML;

                var req = $.ajax({
                    type: "GET",
                    url: "AjaxGetHtml.aspx/GetUserDetails",
                    contentType: "application/json; charset=utf-8",
                    dataType: "html",
                    data: "id=" + id
                });

                req.done(function (data) {
                    $("#userDetailsContainer").empty();
                    $("#userDetailsContainer").append(data);

                    if ($("#userDetailsContainer").css("display") == "none") {
                        $("#userDetailsContainer").slideToggle();
                    }
                });

                req.fail(function (xhr, status) { alert("FAILED: " + status); });
            });

            if ($("#userTableContainer").css("display") == "none") {
                $("#userTableContainer").slideToggle();
            }
        });

        req.fail(function (xhr, status) { alert("FAILED: " + status); });
    });
});
