﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Web.Services;
using System.Web.Script.Services;
using DataSource;

public partial class AspAjax : System.Web.UI.Page
{
	protected void Page_Load(object sender, EventArgs e)
	{
        // Create grid views with headers
		InitUsersGrid();
		InitUserDetailsGrid();
	}

	void InitUsersGrid()
	{
		var dt = new DataTable();
		dt.Columns.AddRange(new DataColumn[]
		{
			new DataColumn("ID"),
			new DataColumn("UserName"),
			new DataColumn("FirstName"),
			new DataColumn("LastName")
		});
		gridViewUsers.DataSource = dt;
		gridViewUsers.DataBind();
	}

	void InitUserDetailsGrid()
	{
		var dt = new DataTable();
		dt.Columns.AddRange(new DataColumn[]
		{
			new DataColumn(" "),
			new DataColumn("  ")
		});
		gridViewUserDetails.DataSource = dt;
		gridViewUserDetails.DataBind();
	}

	[WebMethod]
    [ScriptMethod(UseHttpGet = true, ResponseFormat = ResponseFormat.Json)]
    public static List<UserData.UserInfo> GetUsers()
	{
		return UserData.GetUsers();
	}

	[WebMethod]
    [ScriptMethod(UseHttpGet = true, ResponseFormat = ResponseFormat.Json)]
	public static UserData.UserDetails GetUserDetails(string id)
	{
		return UserData.GetUserDetails(id);
	}
}