$(document).ready(function () {

	// Gets a list of users and populates a Users table
	$("#btnLoadUsers").click(function () {
		$("#userDetails").hide();

		var req = $.ajax({
			type: "GET",
			url: "AspAjax.aspx/GetUsers",
			contentType: "application/json; charset=utf-8",
			dataType: "json",
			data: {}
		});

		req.done(function (data) {
			if ($("#usersTable").css("display") == "none") {
				$("#usersTable").slideToggle();
			}
			$("#gridViewUsers tr:not(:first-child)").html("");
			for (var i = 0; i < data.d.length; i++) {
				$("#gridViewUsers").append("<tr>"
				+ "<td>" + data.d[i].ID + "</td>"
				+ "<td>" + data.d[i].UserName + "</td>"
				+ "<td>" + data.d[i].FirstName + "</td>"
				+ "<td>" + data.d[i].LastName + "</td></tr>");
			}
		});

		req.fail(function (xhr, status) { alert("FAILED: " + status); });
	});

	// Gets details for a user and populates a User Details table
	$("#gridViewUsers").delegate('tr', 'click', function () {
		if (!this.rowIndex) return;
		var id = this.cells[0].innerHTML;
		var req = $.ajax({
			type: "GET",
			url: "AspAjax.aspx/GetUserDetails",
			contentType: "application/json; charset=utf-8",
			dataType: "json",
			data: "id=" + id
		});

		req.done(function (data) {
			if ($("#userDetails").css("display") == "none") {
				$("#userDetails").slideToggle();
			}
			$("#gridViewUserDetails tr:not(:first-child)").html("");
			$("#gridViewUserDetails :first-child").css('width', '100px');
			$("#gridViewUserDetails").append(
				"<tr><td>UserName:</td><td>" + data.d.Info.UserName + "</td></tr>"
				+ "<tr><td>First Name:</td><td>" + data.d.Info.FirstName + "</td></tr>"
				+ "<tr><td>Last Name:</td><td>" + data.d.Info.LastName + "</td></tr>"
				+ "<tr><td>Address:</td><td>" + data.d.Address + "</td></tr>"
				+ "<tr><td>City:</td><td>" + data.d.City + "</td></tr>"
				+ "<tr><td>State:</td><td>" + data.d.State + "</td></tr>"
				+ "<tr><td>Zip:</td><td>" + data.d.PostalCode + "</td></tr>");
		});

		req.fail(function (xhr, status) { alert("FAILED: " + status); });
	});

});
