﻿using System;
using System.Data;
using System.Web.UI.WebControls;
using DataSource;

public partial class FullPostback : System.Web.UI.Page
{
	protected void OnClickLoadUsers(object sender, EventArgs e)
	{
        // Show/hide divs
        usersTable.Visible = true;
        userDetails.Visible = false;

		// Get a list of users
        var userList = UserData.GetUsers();

		// Create a data table
        var dt = new DataTable();
		dt.Columns.Add("ID");
		dt.Columns.Add("Username");
		dt.Columns.Add("First Name");
		dt.Columns.Add("Last Name");

		// Fill the data table
        foreach (var user in userList)
		{
			dt.Rows.Add(new object[] { user.ID, user.UserName, user.FirstName, user.LastName });
		}

		// Set the grid view data
        gridViewUsers.DataSource = dt;
		gridViewUsers.DataBind();
	}

    protected void OnDataBoundGridViewUsers(object sender, EventArgs e)
    {
        // Hide the first (ID) column.
        if (gridViewUsers.HeaderRow != null && gridViewUsers.HeaderRow.Cells.Count > 0)
        {
            gridViewUsers.HeaderRow.Cells[1].Visible = false;
        }
        foreach (GridViewRow row in gridViewUsers.Rows)
        {
            row.Cells[1].Visible = false;
        }
    }

	protected void OnSelectedIndexChangedGridViewUsers(object sender, EventArgs e)
	{
        // Show the details div
        userDetails.Visible = true;

		// Get the id from the selected row
        var row = gridViewUsers.SelectedRow;
		var id = row.Cells[1].Text;

        // Get the user details
		var details = UserData.GetUserDetails(id);

		// Create a data table
        var dt = new DataTable();
        dt.Columns.Add();
        dt.Columns.Add();

        // Populate the data table
        dt.Rows.Add("Username", details.Info.UserName);
		dt.Rows.Add("First Name:", details.Info.FirstName);
		dt.Rows.Add("Last Name:", details.Info.LastName);
		dt.Rows.Add("Address:", details.Address);
		dt.Rows.Add("City:", details.City);
		dt.Rows.Add("State:", details.State);
        dt.Rows.Add("Zip:", details.PostalCode);

		// Set the grid view data
        gridViewUserDetails.DataSource = dt;
		gridViewUserDetails.DataBind();
	}
}
