package security

import be.objectify.deadbolt.scala.{ DynamicResourceHandler, DeadboltHandler }
import play.api.mvc.{ Request, Result, Results }
import be.objectify.deadbolt.core.models.Subject

class MyDeadboltHandler(dynamicResourceHandler: Option[DynamicResourceHandler] = None) extends DeadboltHandler {

  def beforeAuthCheck[A](request: Request[A]) = None

  def getDynamicResourceHandler[A](request: Request[A]): Option[DynamicResourceHandler] = None

  def getSubject[A](request: Request[A]): Option[Subject] =
    request.session.get("user").map(u => models.User(u))

  import scala.concurrent.Future
  import scala.concurrent.ExecutionContext.Implicits.global
  def onAuthFailure[A](request: Request[A]) = {
    Future.successful(Results.Forbidden(views.html.authFailed()))
  }
}