package test

import org.specs2.mutable._

import play.api.test._
import play.api.test.Helpers._

class IntegrationSpec extends Specification {

  def login(username: String, password: String)(implicit browser: TestBrowser) = {
    browser.goTo("http://localhost:3333/")

    browser.title must beEqualTo("Ajax")

    browser.$("#username").text(username)
    browser.$("#password").text(password)
    browser.$("#submit").click
  }

  "Application" should {

    "allow a correct login" in {
      running(TestServer(3333), HTMLUNIT) { implicit browser =>

        login("bob", "bobpass")

        browser.pageSource must contain("Welcome bob")
      }
    }

    "reject an incorrect login" in {
      running(TestServer(3333), HTMLUNIT) { implicit browser =>

        login("fred", "fredpass")
 
        browser.title must beEqualTo("Ajax")
        browser.pageSource must contain("Invalid username or password")
      }
    }

    "allow a logged-in user to view page B" in {
      running(TestServer(3333), HTMLUNIT) { implicit browser =>

      	login("bob", "bobpass")

        browser.pageSource must contain("Welcome bob")

        browser.$("#pageB").click

        browser.title must beEqualTo("Page B")
      }
    }

    "prevent unauthorized access to page B" in {
      running(TestServer(3333), HTMLUNIT) { browser =>

        browser.goTo("http://localhost:3333/pageB")

        browser.title must beEqualTo("Authorization Failed")
      }
    }

    "allow a logged-in user to make an ajax request" in {
      running(TestServer(3333), HTMLUNIT) { implicit browser =>

      	login("bob", "bobpass")

        browser.pageSource must contain("Welcome bob")

        browser.$("#btn1").click

        browser.await.atMost(3, java.util.concurrent.TimeUnit.SECONDS).until("#div1").withText.startsWith("Pressed 1").isPresent

        browser.$("#div1").first.getText must contain("Pressed 1")

      }
    }
    
  }

}