package models

import be.objectify.deadbolt.core.models._
import play.libs.Scala

class SecurityRole(val roleName: String) extends Role {
  def getName: String = roleName
}

class UserPermission(val value: String) extends Permission {
  def getValue: String = value
}

case class User(name: String = "") extends Subject {

  def getRoles: java.util.List[SecurityRole] = {
    Scala.asJava(List[SecurityRole]()) // no roles needed
  }

  def getPermissions: java.util.List[UserPermission] = {
    Scala.asJava(List[UserPermission]()) // no permissions needed
  }

  def getIdentifier: String = name
}

object User {
  import play.api.Play
  import play.api.Play.current
  private lazy val adminUsername = Play.current.configuration.getString("login.username").getOrElse("")
  private lazy val adminPassword = Play.current.configuration.getString("login.password").getOrElse("")

  def authenticate(username: String, password: String): Option[User] =
    if ((adminUsername == username) && (adminPassword == password))
      Some(User(username))
    else
      None
}