import sbt._
import Keys._
import play.Project._

object ApplicationBuild extends Build {

  val appName         = "ajax"
  val appVersion      = "1.0-SNAPSHOT"

  val appDependencies = Seq(
    jdbc,
    anorm,
    cache,
    
    // https://github.com/schaloner/deadbolt-2
    "be.objectify" %% "deadbolt-scala" % "2.2-RC2"
  )

  val main = play.Project(appName, appVersion, appDependencies).settings(
      resolvers += Resolver.url("Objectify Play Repository", url("http://schaloner.github.io/releases/"))(Resolver.ivyStylePatterns),
      resolvers += Resolver.url("Objectify Play Snapshot Repository", url("http://schaloner.github.io/snapshots/"))(Resolver.ivyStylePatterns)
  )

}
