/*
 * ConverterClient.java
 */

package com.ociweb.jini.client;

import com.ociweb.jini.shared.Converter;
import com.ociweb.jini.shared.MorseConverter;
import com.ociweb.jini.shared.UpcaseConverter;
import java.rmi.RMISecurityManager;
import java.rmi.RemoteException;
import net.jini.core.lookup.ServiceRegistrar;
import net.jini.core.lookup.ServiceTemplate;
import net.jini.discovery.DiscoveryEvent;
import net.jini.discovery.DiscoveryListener;
import net.jini.discovery.LookupDiscovery;

public class ConverterClient implements DiscoveryListener {
  private static final String MORSE_SERVER_TYPE = "morse";
  private static final String UPCASE_SERVER_TYPE = "upcase";
  private static String server = "";
  
  private Class[] classes = null;
  
  /** Creates a new instance of MorseConverterClient */
  public ConverterClient() {
    if (MORSE_SERVER_TYPE.equals(server)) {
      classes = new Class[] {MorseConverter.class};
    } else if (UPCASE_SERVER_TYPE.equals(server)) {
      classes = new Class[] {UpcaseConverter.class};
    }
        // setup the RMI security manager 
    System.setSecurityManager(new RMISecurityManager());
    
    LookupDiscovery discover = null;
    try {
      discover = new LookupDiscovery(LookupDiscovery.ALL_GROUPS);
    } catch (Exception e) {
      System.err.println("Discovery failed " + e.toString());
      System.exit(1);
    }
    discover.addDiscoveryListener(this);
  }

  public void discovered(DiscoveryEvent evt) {
    ServiceRegistrar[] registrars = evt.getRegistrars();
    Converter converter = null;
    
    ServiceTemplate template = new ServiceTemplate(null, classes, null);
    
    for (int n=0; n < registrars.length; n++) {
      System.out.println("Lookup service found");
      ServiceRegistrar registrar = registrars[n];
      try {
        if (MORSE_SERVER_TYPE.equals(server)) {
          converter = (MorseConverter) registrar.lookup(template);
        } else if (UPCASE_SERVER_TYPE.equals(server)) {
          converter = (UpcaseConverter) registrar.lookup(template);          
        }
      } catch (RemoteException ex) {
        ex.printStackTrace();
        continue;
      }
      
      if (converter == null) {
        System.out.println("Converter was null");
        continue;
      }
      
      // use the service to convert some text
      String textStr = "";
      try {
        textStr = "Learning Jini!";
        System.out.println(textStr);
        System.out.println(converter.convert(textStr));

        textStr = "Practicing Jini!";
        System.out.println(textStr);
        System.out.println(converter.convert(textStr));
        
        textStr = "Teaching Jini!";
        System.out.println(textStr);
        System.out.println(converter.convert(textStr));

        textStr = "Implementing Jini!";
        System.out.println(textStr);
        System.out.println(converter.convert(textStr));
        
      } catch (RemoteException rex) {
        System.err.println(rex.toString());
        continue;
      }
      System.exit(0);
    }
  }

  public void discarded(DiscoveryEvent evt) {
  }
    
  public static void main(String[] args) {
    server = System.getProperty("server");
    if (server == null) {
      System.err.println("You must specify -Dserver=[upcase|morse]");
      System.exit(1);
    }
    
    new ConverterClient();
    
    
    try {
      Thread.currentThread().sleep(100000L);
    } catch(java.lang.InterruptedException ex) {
      // do nothing 
    }
  }
  
}
