package com.ociweb.jnb.oct;

import java.rmi.RemoteException;
import net.jini.core.lookup.ServiceRegistrar;
import net.jini.discovery.DiscoveryEvent;
import net.jini.discovery.DiscoveryListener;
import net.jini.discovery.LookupDiscovery;
/*
 * MulticastRegister.java
 *
 * Created on September 15, 2007, 9:38 PM
 */
public class MulticastJiniLauncher implements DiscoveryListener {
  
  /** Creates a new instance of MulticastRegister */
  public MulticastJiniLauncher() {
    System.setSecurityManager(new java.rmi.RMISecurityManager());
    LookupDiscovery discover = null;
    
    try {
      discover = new LookupDiscovery(LookupDiscovery.ALL_GROUPS);
    } catch(Exception ex) {
      System.err.println(ex.toString());
      ex.printStackTrace();
      System.exit(1);
    }
    discover.addDiscoveryListener(this);
  }
  
  public void discovered(DiscoveryEvent discoveryEvent) {
    ServiceRegistrar[] registrars = discoveryEvent.getRegistrars();
    for (int i=0; i < registrars.length; i++) {
      ServiceRegistrar registrar = registrars[i];
      
      try {
        System.out.println("found a service locator at " + 
                            registrar.getLocator().getHost() + 
                           " listening on port " + registrar.getLocator().getPort());
      } catch (RemoteException e) {
        e.printStackTrace();
      }
    }
  }

  public void discarded(DiscoveryEvent discoveryEvent) {
    ServiceRegistrar[] registrars = discoveryEvent.getRegistrars();
    
    for (int i=0; i < registrars.length; i++) {
      ServiceRegistrar registrar = registrars[i];
      
      try {
        System.out.println("Service locator at " + 
                            registrar.getLocator().getHost() +
                            " listening on port " + registrar.getLocator().getPort() +
                            " has been shutdown.");
      } catch (RemoteException ex) {
        ex.printStackTrace();
      }
    }
  }

  static public void main(String[] args) {
    new MulticastJiniLauncher();
    
    try {
      Thread.currentThread().sleep(10000L);
    } catch(java.lang.InterruptedException ie) {
      //do nothing
    }
  }

}