/*
 * MorseConverter.java
 *
 * Created on September 16, 2007, 10:24 PM
 */

package com.ociweb.jini.server;

import com.ociweb.jini.shared.MorseConverter;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.HashMap;

/**
 *
 * @author rwithers
 */
public class MorseConverterImpl implements MorseConverter, Serializable {
  
  private static final HashMap morseHash = new HashMap();
  
  /* static initializer */
  static {
    morseHash.put("A", MorseConstants.A);
    morseHash.put("B", MorseConstants.B);
    morseHash.put("C", MorseConstants.C);
    morseHash.put("D", MorseConstants.D);
    morseHash.put("E", MorseConstants.E);
    morseHash.put("F", MorseConstants.F);
    morseHash.put("G", MorseConstants.G);
    morseHash.put("H", MorseConstants.H);
    morseHash.put("I", MorseConstants.I);
    morseHash.put("J", MorseConstants.J);
    morseHash.put("K", MorseConstants.K);
    morseHash.put("L", MorseConstants.L);
    morseHash.put("M", MorseConstants.M);
    morseHash.put("N", MorseConstants.N);
    morseHash.put("O", MorseConstants.O);
    morseHash.put("P", MorseConstants.P);
    morseHash.put("Q", MorseConstants.Q);
    morseHash.put("R", MorseConstants.R);
    morseHash.put("S", MorseConstants.S);
    morseHash.put("T", MorseConstants.T);
    morseHash.put("U", MorseConstants.U);    
    morseHash.put("V", MorseConstants.V);    
    morseHash.put("W", MorseConstants.W);    
    morseHash.put("X", MorseConstants.X);    
    morseHash.put("Y", MorseConstants.Y);    
    morseHash.put("Z", MorseConstants.Z);    

    morseHash.put("0", MorseConstants.N0);    
    morseHash.put("1", MorseConstants.N1);    
    morseHash.put("2", MorseConstants.N2);    
    morseHash.put("3", MorseConstants.N3);    
    morseHash.put("4", MorseConstants.N4);    
    morseHash.put("5", MorseConstants.N5);    
    morseHash.put("6", MorseConstants.N6);    
    morseHash.put("7", MorseConstants.N7);    
    morseHash.put("8", MorseConstants.N8);    
    morseHash.put("9", MorseConstants.N9);    
    
    morseHash.put("&",MorseConstants.ampersand);
    morseHash.put("'",MorseConstants.apostrophe);
    morseHash.put("@",MorseConstants.at_sign);
    morseHash.put(")",MorseConstants.closed_paren);
    morseHash.put(":",MorseConstants.colon);
    morseHash.put(",",MorseConstants.comma);
    morseHash.put("$",MorseConstants.dollar_sign);
    morseHash.put("=",MorseConstants.equals);
    morseHash.put("!",MorseConstants.exclamation_mark);
    morseHash.put("-",MorseConstants.minus_sign);
    morseHash.put("(",MorseConstants.open_paren);
    morseHash.put(".",MorseConstants.period);
    morseHash.put("+",MorseConstants.plus_sign);
    morseHash.put("?",MorseConstants.question_mark);
    morseHash.put("\"",MorseConstants.quotation);
    morseHash.put(":",MorseConstants.semicolon);
    morseHash.put("/",MorseConstants.slash);
    morseHash.put("_",MorseConstants.underscore);
    morseHash.put(" ",MorseConstants.space);
  }
  
  /** Creates a new instance of MorseConverter */
  public MorseConverterImpl() {
  }
  
  /**
   * This method takes a text string as input and returns the morse code equivalent.
   *
   * e.g. 
   *      If the input text is "Learning Jini!"
   *
   *      Then the converted text should be: 
   *      .-.. . .- .-. -. . -. --.    .--- . -. . -.-.--
   *      
   *      Notice that there is a space between each "letter" and two spaces 
   *      between each "word" for readability. 
   *
   *      If the input text is changed to Learning Jini%
   *
   *      Then the converted text will be: 
   *
   *      .-.. . .- .-. -. . -. --.    .--- . -. . #
   *
   *      In this case the pound sign represents a character that the 
   *      converter didn't recognize.  This character was the % symbol.  
   *
   * @param textToConvert - string representing the text to convert to morse code.
   * @return String - the converted string 
   */
  public String convert(String textToConvert) {
    StringBuffer convertedBuf = new StringBuffer();
        
    if (textToConvert.length() > 0) {
      String chrStr = "";
      char[] carray = textToConvert.toCharArray();
      
      for (int i=0; i < carray.length; i++) {
        chrStr = carray[i] + "";
        
        if (morseHash.containsKey(chrStr.toUpperCase())) {
          convertedBuf.append(morseHash.get(chrStr.toUpperCase()) + " ");
        } else {
          convertedBuf.append("#"); // we didn't understand some of the input
        }
      }
    }
    
    return convertedBuf.toString();
  }
}
