/*
 * MorseConverterServer.java
 *
 */

package com.ociweb.jini.server;

import com.ociweb.jini.shared.UpcaseConverter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.rmi.RMISecurityManager;
import net.jini.core.entry.Entry;
import net.jini.core.lease.Lease;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceItem;
import net.jini.core.lookup.ServiceRegistrar;
import net.jini.core.lookup.ServiceRegistration;
import net.jini.discovery.DiscoveryEvent;
import net.jini.discovery.DiscoveryListener;
import net.jini.discovery.LookupDiscovery;
import net.jini.lease.LeaseListener;
import net.jini.lease.LeaseRenewalEvent;
import net.jini.lease.LeaseRenewalManager;
import net.jini.lookup.entry.Name;
import net.jini.lookup.entry.ServiceInfo;

/**
 *
 * @author rwithers
 */
public class UpcaseConverterServer implements DiscoveryListener, LeaseListener {
 
  /** Member delcarations **/
  private String idFileName = "UpcaseConverter.id";
  private LookupDiscovery discover = null;
  private ServiceRegistrar[] registrars = null;
  
  private Entry[] entries = { new Name("Upcase"),
                              new ServiceInfo(UpcaseConverter.class.toString(), "OCI", "", "", "", "")};
  
  protected LeaseRenewalManager leaseManager = new LeaseRenewalManager();
  protected ServiceID serverId = null;
  protected UpcaseConverterImpl server = null;
  
  /** Creates a new instance of MorseConverterServer */
  public UpcaseConverterServer() {
    server = new UpcaseConverterImpl();
    
    // try to load service id from file.  It isn't an error if we can't load it
    // if this is an initial run attempt we may not have an id. 
    DataInputStream din = null;
    try {
      din = new DataInputStream(new FileInputStream(idFileName));
      serverId = new ServiceID(din);
    } catch(Exception ex) {
      // throw an exceptions on the floor.
    }
    
    // setup the RMI security manager 
    System.setSecurityManager(new RMISecurityManager());
    
    try {
      discover = new LookupDiscovery(LookupDiscovery.ALL_GROUPS);
    } catch (Exception e) {
      System.err.println("Discovery failed " + e.toString());
      System.exit(1);
    }
    discover.addDiscoveryListener(this);
  }
  
  public static void main(String[] args) {
    UpcaseConverterServer mcs = new UpcaseConverterServer();
    
    // Keep server running to maintain the lease and allow for 
    // locator discovery. 
    Object keepAlive = new Object();
    synchronized(keepAlive) {
      try {
        keepAlive.wait();
      } catch (InterruptedException ex) {
        // do nothing
      }
    }
  }

  public void discovered(DiscoveryEvent evt) {
    registrars = evt.getRegistrars();
    
    for (int n=0; n<registrars.length; n++) {
      ServiceRegistrar registrar = registrars[n];
      
      ServiceItem item = new ServiceItem(serverId, server, entries);
      
      ServiceRegistration reg = null;
      try {
        reg = registrar.register(item, Lease.FOREVER);
      } catch(java.rmi.RemoteException rex) {
        System.err.println("Register exception: " + rex.toString());
        continue;
      }
      System.out.println("Service registered with id " + reg.getServiceID());
      
      leaseManager.renewUntil(reg.getLease(), Lease.FOREVER, this);
      
      if (serverId == null) {
        serverId = reg.getServiceID();
        
        DataOutputStream dout = null;
        try {
          dout = new DataOutputStream(new FileOutputStream(idFileName));
          serverId.writeBytes(dout);
          dout.flush();
        } catch(Exception ex) {
          // ignore
        }
      }      
    }
  }

  public void discarded(DiscoveryEvent discoveryEvent) {
    System.out.println("Received a discarded event.");
  }

  public void notify(LeaseRenewalEvent evt) {
    System.out.println("Lease expired " + evt.toString());
  }

}
