package com.ociweb.jnb.oct;

import java.rmi.RMISecurityManager;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.lookup.ServiceRegistrar;
/*
 * JiniLauncher.java
 */
public class JiniLauncher {
    
    /** Creates a new instance of JiniLauncher */
    public JiniLauncher() {
    }

    public void launch() {
        LookupLocator lookup = null;
        ServiceRegistrar registrar = null;
        
        System.setSecurityManager(new RMISecurityManager());
        
        try {
            lookup = new LookupLocator("jini://localhost");
        } catch (java.net.MalformedURLException ex) {
            System.err.println("Lookup failed: " + ex.toString());
            System.exit(1);
        }
        
        try {
            registrar = lookup.getRegistrar();
        } catch (java.io.IOException ioe) {
            System.err.println("Registrar search failed: " + ioe.toString());
            System.exit(1);            
        } catch (java.lang.ClassNotFoundException cnfe) {
            System.err.println("Registrar search failed: " + cnfe.toString());
            System.exit(1);                        
        }
        System.out.println("Registrar Found");
        // the code takes separate routes from here based on whether it is a 
        // client or a service.
    }
        
    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        JiniLauncher launcher = new JiniLauncher();
        
        // Acquiring a registrar via the unicast approach.
        launcher.launch();
    }
}
