package net.gilstraps.server;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.sun.grizzly.http.SelectorThread;
import com.sun.jersey.api.container.grizzly.GrizzlyWebContainerFactory;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

/**
 * Main method of the Cha-ching server
 */
public class GuiceBootstrap {


    private static class SelectorThreadProvider implements Provider<SelectorThread> {

        public SelectorThread get() {
            try {
                String baseURI = "http://localhost:9998/";
                final Map<String, String> initParams = new HashMap<String, String>();
                initParams.put("com.sun.jersey.config.property.packages", "net.gilstraps.server");
                return GrizzlyWebContainerFactory.create(baseURI, initParams);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void main(String[] args) throws IOException {

        Module myModule = new AbstractModule() {
            @Override
            protected void configure() {
                bind(SelectorThread.class).toProvider(SelectorThreadProvider.class);
            }
        };
        Injector injector = Guice.createInjector(myModule);
        Main myMain = injector.getInstance(Main.class);
        myMain.go();
    }

}