package net.gilstraps.server;

import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import com.sun.grizzly.http.SelectorThread;
import java.io.IOException;

/**
 * Main method of the services
 */
public class Main {
    private static final String CONFIG_FILES_PROPERTY = "net.gilstraps.ioc.config.files";
    private static final String[] DEFAULT_IOC_CONFIG_FILES = {"spring-config.xml"};

    private static final String SELECTOR_THREAD_NAME = "grizzlySelectorThread";

    public static void main(String[] args) throws IOException {
        String[] configFiles = getResourceFiles();

        BeanFactory beanFactory = new ClassPathXmlApplicationContext(configFiles);
        SelectorThread selector = (SelectorThread) beanFactory.getBean( SELECTOR_THREAD_NAME );
        //noinspection ResultOfMethodCallIgnored
        System.in.read();
        selector.stopEndpoint();
        System.exit(0);
    }

    private static String[] getResourceFiles() {
        String configFilesProperty = System.getProperty(CONFIG_FILES_PROPERTY);
        if (configFilesProperty != null) {
            return configFilesProperty.split(",");
        }
        return DEFAULT_IOC_CONFIG_FILES;
    }
}
