package net.gilstraps.server;

import com.sun.grizzly.http.SelectorThread;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.container.grizzly.GrizzlyWebContainerFactory;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import static junit.framework.Assert.assertEquals;
import static org.junit.Assert.assertTrue;
import static org.junit.Assert.assertArrayEquals;

public class Test3b {

    private SelectorThread selector;

    @org.junit.Before
    public void createService() throws IOException {
        Map<String, String> initParams = new HashMap<String, String>();
        initParams.put("com.sun.jersey.config.property.packages", "net.gilstraps.server");
        selector = GrizzlyWebContainerFactory.create("http://localhost:9998/", initParams);
    }

    @org.junit.After
    public void DestroyService() {
        selector.stopEndpoint();
        selector = null;
    }

    @org.junit.Test
    public void testF22Html() {
        try {
            File expected = new File("f22.html");
            long fileSize = expected.length();
            if (fileSize > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("File it larger than a StringWriter can hold");
            }
            int size = (int) fileSize;
            BufferedReader r = new BufferedReader(new FileReader(expected), size);
            char[] chars = new char[size];
            int readChars = r.read(chars);
            if (readChars != size) {
                throw new RuntimeException("Failed to read all chars of the expected result html file");
            }
            final String expectedText = new String(chars);

            Client client = new Client();
            WebResource f22 = client.resource("http://localhost:9998/planes/f22/f22.html");
//            String returnedHTML = f22.accept(MediaType.TEXT_HTML_TYPE).get(String.class);
            ClientResponse response = f22.accept(MediaType.TEXT_HTML_TYPE).get(ClientResponse.class);
            String returnedHTML = response.getEntity(String.class);
            assertEquals("Expected and actual HTML don't match", expectedText, returnedHTML);
        }
        catch (FileNotFoundException e) {
            AssertionError ae = new AssertionError("File containing expected HTML not found!");
            ae.initCause(e);
            throw ae;
        }
        catch (IOException e) {
            AssertionError ae = new AssertionError("Problems reading expected text!");
            ae.initCause(e);
            throw ae;
        }
    }

    @org.junit.Test
    public void testF22JPEG() {
        try {
            // Read in our expected result
            File imageFile = new File("f22.jpg");
            long fileSize = imageFile.length();
            if (fileSize > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("File it larger than a StringWriter can hold");
            }
            int size = (int) fileSize;
            byte[] expectedBytes = new byte[size];
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(imageFile), size);
            int bytesRead = bis.read(expectedBytes);
            assertEquals(size, bytesRead);

            // Request the representation
            Client client = new Client();
            WebResource f22 = client.resource("http://localhost:9998/planes/f22/f22.jpg");
            ClientResponse response = f22.accept(MediaType.WILDCARD).get(ClientResponse.class);
            MultivaluedMap<String,String> headers = response.getHeaders();
            for ( String key : headers.keySet() ) {
                System.out.println( key + "=" + headers.get(key) );
            }
            byte[] returnedBytes = new byte[0];
            returnedBytes = response.getEntity(returnedBytes.getClass());

            // Compare the two sets of bytes to make sure they match
            assertEquals(size, returnedBytes.length);
            assertArrayEquals(expectedBytes,returnedBytes);
        }
        catch (FileNotFoundException e) {
            AssertionError ae = new AssertionError("File containing expected HTML not found!");
            ae.initCause(e);
            throw ae;
        }
        catch (IOException e) {
            AssertionError ae = new AssertionError("Problems reading expected text!");
            ae.initCause(e);
            throw ae;
        }
    }
}
