#include "Database_i.h"

#include "Shared/LNK4248.h"
SUPPRESS_LNK4248_CORBA

Database_i::Database_i (gcroot<DataLib::Database^> database) : database_(database)
{
}


Database_i::~Database_i (void)
{
}


::CORBA::Boolean Database_i::CreateItem (
	const ::CORBA::WChar * description,
    ::CORBA::LongLong_out id
	)
{
	System::String^ netDescription = gcnew System::String(description);
	::CORBA::Boolean result = database_->CreateItem(netDescription, id);
	delete netDescription;
	return result;
}


::CORBA::Boolean Database_i::ReadItem (
    ::CORBA::LongLong id,
    ::CORBA::WString_out description)
{
	System::String^ netDescription;
	::CORBA::Boolean result = database_->ReadItem(id, netDescription);
	if (result) {
		pin_ptr<const wchar_t> s = PtrToStringChars(netDescription);
		description = s;
	}
	return result;
}


::CORBA::Boolean Database_i::UpdateItem (
    ::CORBA::LongLong id,
    const ::CORBA::WChar * description)
{
	System::String^ netDescription = gcnew System::String(description);
	::CORBA::Boolean result = database_->UpdateItem(id, netDescription);
	return result;
}


::CORBA::Boolean Database_i::DeleteItem (
    ::CORBA::LongLong id)
{
	::CORBA::Boolean result =  database_->DeleteItem(id);
	return result;
}


