using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;


namespace ClientNS
{
    public partial class Client : Form
    {
        DataServerConnector dataConnector_ = new DataServerConnector();

        public Client()
        {
            try
            {
                InitializeComponent();
                dataConnector_.Start();
            }
            catch (Exception ex)
            {
                MessageBox.Show("Exception: " + ex);
            }
        }

        // add a message to the list view, but be careful if called from another thread
        private void Log(string s)
        {
            if (InvokeRequired)
                BeginInvoke(new MethodInvoker(delegate { listView.Items.Add(s); }));
            else
                listView.Items.Add(s);
        }


        // implement UI method
        private void bCreate_Click(object sender, EventArgs e)
        {
            try
            {
                // if input is blank, do nothing, else create the item
                if (String.IsNullOrEmpty(tCreateDesc.Text))
                    return;

                // invoke the method
                long id = 0;
                if (dataConnector_.CreateItem(tCreateDesc.Text, ref id))
                    Log("Item '" + tCreateDesc.Text + "' created with id " + id);
                else
                    Log("Item '" + tCreateDesc.Text + "' could not be created");
            }
            catch (DataConnectorException ex)
            {
                Log(ex.Message);
            }

            // after completion (or failure) clear the input
            tCreateDesc.Text = "";
        }

        private void bRead_Click(object sender, EventArgs e)
        {
            try
            {
                if (String.IsNullOrEmpty(tReadID.Text))
                    return;
                long id = Convert.ToInt64(tReadID.Text);

                string description = "";
                if (dataConnector_.ReadItem(id, ref description))
                    Log("Item " + id + " has description '" + description + "'");
                else
                    Log("Item " + id + " could not be read");
            }
            catch (DataConnectorException ex)
            {
                Log(ex.Message);
            }

            tReadID.Text = "";
        }

        private void bUpdate_Click(object sender, EventArgs e)
        {
            try
            {
                if (String.IsNullOrEmpty(tUpdateID.Text))
                    return;
                if (String.IsNullOrEmpty(tUpdateDesc.Text))
                    return;

                long id = Convert.ToInt64(tUpdateID.Text);
                if (dataConnector_.UpdateItem(id, tUpdateDesc.Text))
                    Log("Item " + id + " updated with description '" + tUpdateDesc.Text + "'");
                else
                    Log("Item " + id + " could not be updated");
            }
            catch (DataConnectorException ex)
            {
                Log(ex.Message);
            }

            tUpdateID.Text = "";
            tUpdateDesc.Text = "";
        }

        private void bDelete_Click(object sender, EventArgs e)
        {
            try
            {
                if (String.IsNullOrEmpty(tDeleteID.Text))
                    return;

                long id = Convert.ToInt64(tDeleteID.Text);
                if (dataConnector_.DeleteItem(id))
                    Log("Item " + id + " has been deleted");
                else
                    Log("Item " + id + " could not be deleted");
            }
            catch (DataConnectorException ex)
            {
                Log(ex.Message);
            }

            tDeleteID.Text = "";
        }


        // shut down TAO and DDS when the window closes
        private void Client_FormClosing(object sender, FormClosingEventArgs e)
        {
            dataConnector_.Shutdown();
        }
    }
}