#include <iostream>
#include <fstream>
#include <string>
#include <tchar.h>
#include <tao/IORTable/IORTable.h>
#include "Database_i.h"
#include "Shared/LNK4248.h"

using namespace System;

// incomplete types generate LNK4248 warnings when compiled for .NET
SUPPRESS_LNK4248_CORBA

// to allow the server to be shut down gracefully with ctrl-c
CORBA::ORB_ptr gOrb_ = NULL;
static BOOL WINAPI ControlCHandler(DWORD /*type*/) {
	std::cout << "Quitting because of ctrl-c" << std::endl;
	if (gOrb_)
		gOrb_->shutdown();
	return TRUE;
}


int ACE_TMAIN(int argc, ACE_TCHAR *argv[]) {
	try {
		// to allow the server to be shut down gracefully with ctrl-c
		SetConsoleCtrlHandler(ControlCHandler, TRUE);

		// initialize the ORB
		CORBA::ORB_var orb = CORBA::ORB_init(argc, argv);
		gOrb_ = orb.in();

		// get a reference to the RootPOA
		CORBA::Object_var obj = orb->resolve_initial_references("RootPOA");
		PortableServer::POA_var poa = PortableServer::POA::_narrow(obj.in());

		// activate the POAManager
		PortableServer::POAManager_var mgr = poa->the_POAManager();
		mgr->activate();

		// open the database - DataServer (for now) maintains one open database connection for all clients
		DataLib::Database database;
		if (!database.Open())
			throw std::exception("Cannot open the database");

		// create the database servant
		Database_i servant(%database);
		PortableServer::ObjectId_var oid = poa->activate_object(&servant);
		CORBA::Object_var database_obj = poa->id_to_reference(oid.in());

		// for corbaloc - start server with -ORBListenEndpoints iiop://machine:port
		CORBA::String_var ior_str = orb->object_to_string(database_obj.in());
		CORBA::Object_var tobj = orb->resolve_initial_references("IORTable");
		IORTable::Table_var table = IORTable::Table::_narrow(tobj.in());
		table->bind("DataServer", ior_str.in());
		std::cout << "DataServer bound to IORTable" << std::endl;

		// accept requests from clients
		orb->run();
		orb->destroy();
	}
	catch (CORBA::Exception& ex) {
		std::cerr << "CORBA exception: " << ex << std::endl;
	}
	catch (std::exception& ex) {
		std::cerr << "Exception: " << ex.what() << std::endl;
	}

	return 0;
}