// CORBA client here
#ifndef __DATACONNECTORLIB_H__
#define __DATACONNECTORLIB_H__

#include "DatabaseC.h"

using namespace System;
using namespace System::Threading;

class DataServerConnectorState {
	CORBA::ORB_var orb_;  // need to keep the orb alive
	Database_var database_;  // the servant, too
public:
	DataServerConnectorState(CORBA::ORB_ptr orb, Database_ptr database);
	Database_ptr DatabasePtr() { return database_; }
	CORBA::ORB_ptr OrbPtr() { return orb_; }
};



// wrap CORBA interaction with a .NET class
public ref class DataServerConnector {
	DataServerConnectorState *state_;  // can't put an unmanaged thing in a ref class, but a pointer to an unmanaged thing is okay
	Thread^ thread_;
	AutoResetEvent startupEvent_;
	void Run();
	static void ThreadStart(Object^ param);
public:
	DataServerConnector();
	~DataServerConnector();
	void Start();
	void Shutdown();
	bool CreateItem(String ^description, Int64 %id);
	bool ReadItem(Int64 id, String^% description);
	bool UpdateItem(Int64 id, String^ description);
	bool DeleteItem(Int64 id);
};


public ref class DataConnectorException : public Exception {
public:
	DataConnectorException(String ^msg) : Exception(msg) {}
};

#endif
