#ifndef __DDSIMPL_H__
#define __DDSIMPL_H__

#include "MessengerTypeSupportImpl.h"
#include "Common/TypeTraits.h"

DEFINE_TYPETRAITS(Messenger::Message)

#include "Common/Common.h"


namespace MessengerNet {
	public value class MessageNet
	{
	public:
		System::String^ from;
		System::String^ subject;
		System::Int32 subject_id;
		System::String^ text;
		System::Int32 count;
	};
}

Messenger::Message Convert(const gcroot<MessengerNet::MessageNet> &sampleParam);
gcroot<MessengerNet::MessageNet> Convert(const Messenger::Message &sample);

class MessengerMessageDataReaderListenerImpl : public DataReaderListenerImplBase<Messenger::MessageDataReader, Messenger::Message> {
	gcroot<EventManager<MessengerNet::MessageNet>^> eventManager_;
public:
	MessengerMessageDataReaderListenerImpl(gcroot<EventManager<MessengerNet::MessageNet>^> eventManager) : eventManager_(eventManager) {}

	void Process(const Messenger::Message &sample) {
		eventManager_->Process(eventManager_, 
			gcnew ProcessEventArgs<MessengerNet::MessageNet>(Convert(sample)));
	}

	void AddHandler(gcroot<EventManager<MessengerNet::MessageNet>::ProcessEventHandler^> handler) {
		eventManager_->Process += handler;
	}
};



typedef Writer<Messenger::Message> MessengerMessageDataWriter;
typedef Reader<Messenger::Message, MessengerMessageDataReaderListenerImpl> MessengerMessageDataReader;

class MessengerMessageDataWriterMap : public EntityMap<MessengerMessageDataWriter> {
	virtual MessengerMessageDataWriter Create(DDSBase *ddsBase, ::DDS::DomainId_t domainId, const char *topic_name) {
		return ddsBase->CreateWriter<Messenger::Message>(domainId, topic_name);
	}
};

class MessengerMessageDataReaderMap : public EntityMap<MessengerMessageDataReader> {
	virtual MessengerMessageDataReader Create(DDSBase *ddsBase, ::DDS::DomainId_t domainId, const char *topic_name) {
		return ddsBase->CreateReader<Messenger::Message>(domainId, topic_name, new MessengerMessageDataReaderListenerImpl(gcnew EventManager<MessengerNet::MessageNet>()));
	}
};


class DDSImpl : public DDSBase {
	MessengerMessageDataWriterMap mapMessengerMessageDataWriter_;
	MessengerMessageDataReaderMap mapMessengerMessageDataReader_;

public:
	DDSImpl(int argc, ACE_TCHAR *argv[]) : DDSBase(argc, argv) {}

	DDS::ReturnCode_t Publish(::DDS::DomainId_t domainId, const char *topic_name, gcroot<MessengerNet::MessageNet> sample) {
		return mapMessengerMessageDataWriter_.Get(this, domainId, topic_name).Write(Convert(sample));
	}

	bool MessengerMessageWaitForSubscriber(::DDS::DomainId_t domainId, const char *topic_name) { 
		return mapMessengerMessageDataWriter_.Get(this, domainId, topic_name).WaitForSubscriber(); 
	}
	bool MessengerMessageWaitForAcknowledgements(::DDS::DomainId_t domainId, const char *topic_name) { 
		return mapMessengerMessageDataWriter_.Get(this, domainId, topic_name).WaitForAcknowledgements(); 
	}

	void Subscribe(::DDS::DomainId_t domainId, const char *topic_name, gcroot<EventManager<MessengerNet::MessageNet>::ProcessEventHandler^> handler) {
		mapMessengerMessageDataReader_.Get(this, domainId, topic_name).GetListener()->AddHandler(handler);
	}

	bool MessengerMessageWaitForPublisherToComplete(::DDS::DomainId_t domainId, const char *topic_name) {
		return mapMessengerMessageDataReader_.Get(this, domainId, topic_name).WaitForPublisherToComplete();
	}
};


public ref class DDSNet {
	DDSImpl *pDDSImpl;

public:
	DDSNet() {
		// convert .NET arguments to standard argc/argv
		int argc;
		char **argv;
		GetArguments(argc, argv);
		pDDSImpl = new DDSImpl(argc, argv);
	}
	~DDSNet() { 
		delete pDDSImpl;
	}

	int Publish(int domainId, System::String^ topic_name, MessengerNet::MessageNet sample) {
		NET_RETHROW_EXCEPTION(return pDDSImpl->Publish(domainId, \
			ConvertToString(topic_name).c_str(), sample));
	}

	bool MessengerMessageWaitForSubscriber(int domainId, System::String^ topic_name) {
		NET_RETHROW_EXCEPTION(return pDDSImpl->MessengerMessageWaitForSubscriber(domainId, \
			ConvertToString(topic_name).c_str()));
	}

	bool MessengerMessageWaitForAcknowledgements(int domainId, System::String^ topic_name) { 
		NET_RETHROW_EXCEPTION(return pDDSImpl->MessengerMessageWaitForAcknowledgements(domainId, \
			ConvertToString(topic_name).c_str()));
	}

	void Subscribe(int domainId, System::String^ topic_name, EventManager<MessengerNet::MessageNet>::ProcessEventHandler^ handler) {
		NET_RETHROW_EXCEPTION(pDDSImpl->Subscribe(domainId, \
			ConvertToString(topic_name).c_str(), handler));
	}

	bool MessengerMessageWaitForPublisherToComplete(int domainId, System::String^ topic_name) {
		NET_RETHROW_EXCEPTION(return pDDSImpl->MessengerMessageWaitForPublisherToComplete(domainId, \
			ConvertToString(topic_name).c_str()));
	}
};


#endif