﻿using System;
using System.Collections.Generic;

namespace Subscriber
{
    public class Print {
	    public void MessengerNetMessageNetEventHandler(Object sender, ProcessEventArgs<MessengerNet.MessageNet> args) {
		    Console.WriteLine("MessageNetEventHandler:    subject = {0}", args.Sample.subject);
		    Console.WriteLine("MessageNetEventHandler: subject_id = {0}", args.Sample.subject_id);
		    Console.WriteLine("MessageNetEventHandler:       from = {0}", args.Sample.from);
		    Console.WriteLine("MessageNetEventHandler:      count = {0}", args.Sample.count);
		    Console.WriteLine("MessageNetEventHandler:       text = {0}", args.Sample.text);
	    }
    };

    static class Program
    {
        [STAThread]
        static void Main()
        {
            try
            {
		        DDSNet dds = new DDSNet();

		        dds.Subscribe(42, "Movie Discussion List",
                    new EventManager<MessengerNet.MessageNet>.ProcessEventHandler(new Print().MessengerNetMessageNetEventHandler));
                dds.MessengerMessageWaitForPublisherToComplete(42, "Movie Discussion List");
                dds.Dispose();

            }
            catch (Exception e)
            {
                Console.WriteLine(e);
                throw;
            }
        }
    }
}