#ifndef DATABASEI_H_
#define DATABASEI_H_

#include "DatabaseS.h"
#include <vcclr.h>
#include "DatabaseNotification/DatabaseNotificationTypeSupportImpl.h"

#if !defined (ACE_LACKS_PRAGMA_ONCE)
#pragma once
#endif /* ACE_LACKS_PRAGMA_ONCE */

class  Database_i
  : public virtual POA_Database
{
	gcroot<DataLib::Database^> database_;
	DatabaseNotificationDataWriter_ptr dataWriter_;

	void WriteNotification(::CORBA::LongLong id, ::CORBA::Char *tableName, NotificationType notificationType);

public:
  // Constructor 
	Database_i (gcroot<DataLib::Database^> database, DatabaseNotificationDataWriter_ptr dataWriter);
  
  // Destructor 
  virtual ~Database_i (void);
  
  virtual
  ::CORBA::Boolean CreateItem (
      const ::CORBA::WChar * description,
      ::CORBA::LongLong_out id);
  
  virtual
  ::CORBA::Boolean ReadItem (
      ::CORBA::LongLong id,
      ::CORBA::WString_out description);
  
  virtual
  ::CORBA::Boolean UpdateItem (
      ::CORBA::LongLong id,
      const ::CORBA::WChar * description);
  
  virtual
  ::CORBA::Boolean DeleteItem (
      ::CORBA::LongLong id);
};


#endif /* DATABASEI_H_  */

