#ifndef __INFOREPOCOLOC_H__
#define __INFOREPOCOLOC_H__

#include <dds/InfoRepo/DCPSInfoRepoServ.h>
#include <ace/Task.h>
#include <ace/Event.h>
#include <ace/ARGV.h>

class InfoRepoStartEvent : public ACE_Event_Handler {
	ACE_Recursive_Thread_Mutex lock_;
	ACE_Condition<ACE_Recursive_Thread_Mutex> cond_;

public:
	InfoRepoStartEvent();
	virtual int handle_timeout(const ACE_Time_Value &, const void *);
	void Install();
	void WaitForStart();
};


class InfoRepoTask : public ACE_Task_Base {
	ACE_ARGV_T<ACE_TCHAR> args_;
	InfoRepo *infoRepo_;
	InfoRepoStartEvent infoRepoStartEvent_;
public:
	InfoRepoTask(ACE_ARGV_T<ACE_TCHAR> &args);
	~InfoRepoTask();
	virtual int svc();
	void WaitForStart();
};


#endif