namespace DataLib
{
    using System;
	using System.Data;
	using System.Data.SQLite;

    public class Database
    {
        private SQLiteConnection connection_ = null;

        // for now, all operations share the same connection, so serialize access
        private Object databaseLock = new Object();  

        public bool Open()
        {
            try
            {
                // open the database (SQLite creates it if the file doesn't exist)
                connection_ = new SQLiteConnection("Data Source=test.sdb");
                connection_.Open();

                // improve performance
                using (SQLiteCommand command = new SQLiteCommand("PRAGMA synchronous = OFF;", connection_))
                    command.ExecuteNonQuery();

                try
                {
                    // create the Items table if missing
                    using (SQLiteCommand command = new SQLiteCommand(
                        "CREATE TABLE Items (" +
                        "  ID INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT," +
                        "  Description VARCHAR(255) NULL DEFAULT ('') )", connection_))
                        command.ExecuteNonQuery();
                }
                catch (SQLiteException e)
                {
                    // anything other than the table existing is an error
                    if (!e.Message.Contains("table Items already exists"))
                        return false;
                }

                return true;
            }
            catch (Exception e)
            {
                Console.WriteLine(e);
                return false;
            }
        }

        public void Close()
        {
            if (connection_ != null)
                connection_.Close();
        }

        public bool CreateItem(string description, out Int64 id)
        {
            lock (databaseLock)
            {
                id = 0;

                // to guarantee last_insert_rowid() corresponds to this specific INSERT
                // likely redundant with the databaseLock, but for show
                SQLiteTransaction transaction = null;  
                try
                {
                    transaction = connection_.BeginTransaction();
                    using (SQLiteCommand command1 = new SQLiteCommand(
                        "INSERT INTO Items (Description) VALUES (@descparam)", connection_),
                        command2 = new SQLiteCommand("SELECT last_insert_rowid();", connection_))
                    {
                        command1.Parameters.AddWithValue("@descparam", description);
                        command1.Transaction = transaction;
                        command2.Transaction = transaction;
                        if (command1.ExecuteNonQuery() == 1)
                        {
                            id = Convert.ToInt64(command2.ExecuteScalar());
                            transaction.Commit();
                            return true;
                        }
                    }
                }
                catch (Exception e)
                {
                    Console.WriteLine(e);
                }
                transaction.Rollback();
                return false;
            }
        }


        public bool ReadItem(Int64 id, out string description)
        {
            description = "";
            lock (databaseLock)
            {
                try
                {
                    using (SQLiteCommand command = new SQLiteCommand(
                        "SELECT Description FROM Items WHERE ID = " + id, connection_))
                    {
                        using (IDataReader r = command.ExecuteReader())
                        {
                            if (r.Read())
                            {
                                description = Convert.ToString(r["Description"]);
                                return true;
                            }
                        }
                    }
                }
                catch (Exception e)
                {
                    Console.WriteLine(e);
                }
            }
            return false;
        }


        public bool UpdateItem(Int64 id, string description)
        {
            lock (databaseLock)
            {
                try
                {
                    using (SQLiteCommand command = new SQLiteCommand(
                        "UPDATE Items SET Description = @descparam WHERE ID = " + id, connection_))
                    {
                        command.Parameters.AddWithValue("@descparam", description);
                        return command.ExecuteNonQuery() == 1;
                    }
                }
                catch (Exception e)
                {
                    Console.WriteLine(e);
                }
            }
            return false;
        }


        public bool DeleteItem(Int64 id)
        {
            lock (databaseLock)
            {
                try
                {
                    using (SQLiteCommand command = new SQLiteCommand(
                        "DELETE FROM Items WHERE ID = " + id, connection_))
                        return command.ExecuteNonQuery() == 1;  // can't delete if already deleted
                }
                catch (Exception e)
                {
                    Console.WriteLine(e);
                }
            }
            return false;
        }
    }

}