#ifndef DATABASENOTIFICATION_DATAREADER_LISTENER_IMPL
#define DATABASENOTIFICATION_DATAREADER_LISTENER_IMPL

#include <dds/DdsDcpsSubscriptionS.h>
#include "DataServerConnectorLib.h"
#include <vcclr.h>

#if !defined (ACE_LACKS_PRAGMA_ONCE)
#pragma once
#endif /* ACE_LACKS_PRAGMA_ONCE */


class DatabaseNotificationDataReaderListenerImpl
	: public virtual OpenDDS::DCPS::LocalObject<DDS::DataReaderListener>
{
	gcroot<DataServerConnector^> dataConnector_;
public:
	DatabaseNotificationDataReaderListenerImpl(gcroot<DataServerConnector^> dataConnector) : 
	  dataConnector_(dataConnector) {}
	virtual ~DatabaseNotificationDataReaderListenerImpl() {}

	virtual void on_requested_deadline_missed (
		DDS::DataReader_ptr /*reader*/,
		const DDS::RequestedDeadlineMissedStatus & /*status*/)
		throw (CORBA::SystemException) {}

	virtual void on_requested_incompatible_qos (
		DDS::DataReader_ptr /*reader*/,
		const DDS::RequestedIncompatibleQosStatus & /*status*/)
		throw (CORBA::SystemException) {}

	virtual void on_liveliness_changed (
		DDS::DataReader_ptr /*reader*/,
		const DDS::LivelinessChangedStatus & /*status*/)
		throw (CORBA::SystemException) {}

	virtual void on_subscription_match (
		DDS::DataReader_ptr /*reader*/,
		const DDS::SubscriptionMatchStatus & /*status*/)
		throw (CORBA::SystemException) {}

	virtual void on_sample_rejected(
		DDS::DataReader_ptr /*reader*/,
		const DDS::SampleRejectedStatus& /*status*/)
		throw (CORBA::SystemException) {}

	virtual void on_data_available(
		DDS::DataReader_ptr reader)
		throw (CORBA::SystemException);

	virtual void on_sample_lost(
		DDS::DataReader_ptr /*reader*/,
		const DDS::SampleLostStatus& /*status*/) 
		throw (CORBA::SystemException) {}
};

#endif /* DATABASENOTIFICATION_DATAREADER_LISTENER_IMPL  */
