#include "InfoRepoColoc.h"
#include <dds/DCPS/Service_Participant.h>

InfoRepoStartEvent::InfoRepoStartEvent() : cond_(lock_) {}

// this won't be fired until the InfoRepo is already running in its reactor
int InfoRepoStartEvent::handle_timeout(const ACE_Time_Value &, const void *) {
	ACE_GUARD_RETURN(ACE_Recursive_Thread_Mutex, guard, this->lock_, -1);
	return cond_.signal();
}

void InfoRepoStartEvent::Install() {
	CORBA::ORB_var orb = TheServiceParticipant->get_ORB();
	ACE_Reactor* reactor = orb->orb_core()->reactor();

	if (reactor->schedule_timer(this, 0, ACE_Time_Value(0,1)) == -1)
		throw std::exception("schedule_timer() returned -1");
}

void InfoRepoStartEvent::WaitForStart() {
	ACE_GUARD(ACE_Recursive_Thread_Mutex, guard, this->lock_);
	cond_.wait();
}




InfoRepoTask::InfoRepoTask(ACE_ARGV_T<ACE_TCHAR> &args) : 
	infoRepo_(0), args_(args.argc(), args.argv()) {}


InfoRepoTask::~InfoRepoTask() {
	if (infoRepo_!=0)
		infoRepo_->shutdown();
	if (thr_mgr()!=0)
		thr_mgr()->wait();
	delete infoRepo_;
}


int InfoRepoTask::svc() {
	if (infoRepo_==0) {
		std::cerr << "InfoRepo not created" << std::endl;
		return 1;
	}

	try {
		infoRepo_->run();
	}
	catch (InfoRepo::InitError& ex) {
		std::cerr << "Unexpected initialization Error: "
			<< ex.msg_ << std::endl;
		return 1;
	}
	catch (const CORBA::Exception& ex) {
		ex._tao_print_exception (
			"ERROR: ::DDS DCPS Info Repo caught exception");
		return 1;
	}

	return 0;
}




void InfoRepoTask::WaitForStart() {
	int argc = args_.argc();
	ACE_TCHAR **argv = args_.argv();

	try {
		infoRepo_ = new InfoRepo(argc, argv);
		infoRepoStartEvent_.Install();
		activate(THR_BOUND, 1, 0, ACE_DEFAULT_THREAD_PRIORITY);
		infoRepoStartEvent_.WaitForStart();
	} catch (InfoRepo::InitError& ex) {
		// can log or take other action, but rethrow as a std::exception
		throw std::exception(ex.msg_.c_str());
	} catch (const CORBA::Exception& /*ex*/) {
		// can log or take other action, but rethrow
		// ex._tao_print_exception("DCPSInfoRepo exception");
		throw;
	}
}
