#include "Database_i.h"

Database_i::Database_i (gcroot<DataLib::Database^> database,
						DatabaseNotificationDataWriter_ptr dataWriter) : database_(database), dataWriter_(dataWriter) 
{
}


Database_i::~Database_i (void)
{
}


void Database_i::WriteNotification(::CORBA::LongLong id, ::CORBA::Char *tableName, NotificationType notificationType) {
	DatabaseNotification notification;
	notification.id = id;
	notification.table_name = ::CORBA::string_dup(tableName);
	notification.notification_type = notificationType;

	std::cout << "Publishing notification" << std::endl;
	int ret = dataWriter_->write(notification, DDS::HANDLE_NIL);
	if (ret != DDS::RETCODE_OK) {
		ACE_ERROR ((LM_ERROR, ACE_TEXT("(%P|%t)ERROR: write returned %d.\n"), ret));
	}
}


::CORBA::Boolean Database_i::CreateItem (
	const ::CORBA::WChar * description,
    ::CORBA::LongLong_out id)
{
	System::String^ netDescription = gcnew System::String(description);
	::CORBA::Boolean result = database_->CreateItem(netDescription, id);
	delete netDescription;
	if (result)
		WriteNotification(id, "Items", NOTIFICATION_CREATED);
	return result;
}


::CORBA::Boolean Database_i::ReadItem (
    ::CORBA::LongLong id,
    ::CORBA::WString_out description)
{
	System::String^ netDescription;
	::CORBA::Boolean result = database_->ReadItem(id, netDescription);
	if (result) {
		pin_ptr<const wchar_t> s = PtrToStringChars(netDescription);
		description = s;
		WriteNotification(id, "Items", NOTIFICATION_READ);
	}
	return result;
}


::CORBA::Boolean Database_i::UpdateItem (
    ::CORBA::LongLong id,
    const ::CORBA::WChar * description)
{
	System::String^ netDescription = gcnew System::String(description);
	::CORBA::Boolean result = database_->UpdateItem(id, netDescription);
	if (result)
		WriteNotification(id, "Items", NOTIFICATION_UPDATED);
	return result;
}


::CORBA::Boolean Database_i::DeleteItem (
    ::CORBA::LongLong id)
{
	::CORBA::Boolean result =  database_->DeleteItem(id);
	if (result)
		WriteNotification(id, "Items", NOTIFICATION_DELETED);
	return result;
}


