#include "DatabaseNotificationDataReaderListenerImpl.h"
#include "DatabaseNotification/DatabaseNotificationTypeSupportC.h"
#include "DatabaseNotification/DatabaseNotificationTypeSupportImpl.h"
#include <dds/DCPS/Service_Participant.h>
#include <ace/streams.h>
#include <sstream>

void DatabaseNotificationDataReaderListenerImpl::on_data_available(DDS::DataReader_ptr reader)
throw (CORBA::SystemException)
{
	try {
		// narrow the data reader
		DatabaseNotificationDataReader_var databaseNotification_dr 
			= DatabaseNotificationDataReader::_narrow(reader);
		if (CORBA::is_nil(databaseNotification_dr.in()))
			throw std::exception("DatabaseNotificationDataReaderListenerImpl::on_data_available:"
				" _narrow failed.");

		// process samples until no more are available
		while (true) {
			DatabaseNotification notification;
			DDS::SampleInfo si;
			DDS::ReturnCode_t status = databaseNotification_dr->take_next_sample(notification, si);

			if (status == DDS::RETCODE_OK) {
				if ((si.instance_state == DDS::ALIVE_INSTANCE_STATE) ||
					(si.instance_state == DDS::NOT_ALIVE_NO_WRITERS_INSTANCE_STATE)) {
					// post an event to the outside world
					dataConnector_->ProcessNotification(
						dataConnector_,
						gcnew ProcessNotificationEventArgs(
							notification.id, 
							gcnew String(notification.table_name.in()), 
							(Notification)notification.notification_type));
				}
				// else if (si.instance_state == DDS::NOT_ALIVE_DISPOSED_INSTANCE_STATE) instance has been disposed

			}
			else if (status == DDS::RETCODE_NO_DATA) 
				break;  // no more samples right now
		}
	}
	catch (CORBA::Exception& ex) {
		std::stringstream ss;
		ss << "Exception in read: " << ex;
		throw gcnew DataConnectorException(gcnew String(ss.str().c_str()));
	}
	catch (std::exception& ex) {
		std::stringstream ss;
		ss << "Exception in read: " << ex.what();
		throw gcnew DataConnectorException(gcnew String(ss.str().c_str()));
	}
}
