package com.ociweb.sett.initial;

/**
 * The main class for this example, it prints a summary of the Solar System
 * (using only the inner planets for simplicity).
 */
public class SolarSystem {

    public static void main(String[] args) {
        CelestialBody sol = new CelestialBody("SOL", 1.98892e30, 6.955e8);
        Satellite mercury = new Satellite("MERCURY", sol, 0.3302e24, 2.4397e6,
                57.91e9);
        Satellite venus = new Satellite("VENUS", sol, 4.869e24, 6.0518e6,
                108.21e9);
        Satellite earth = new Satellite("EARTH", sol, 5.9742e24, 6.3781e6,
                149.6e9);
        Satellite luna = new Satellite("LUNA", earth, 0.07349e24, 1.7381e6,
                0.3844e9);
        earth.setSatellites(new Satellite[]{luna});
        Satellite mars = new Satellite("MARS", sol, 0.64185e24, 3.3962e6,
                227.92e9);
        Satellite phobos = new Satellite("PHOBOS", mars, 1.072e16, 1.11e4,
                9.38e6);
        Satellite deimos = new Satellite("DEIMOS", mars, 1.5e15, 6.2e4,
                2.346e7);
        mars.setSatellites(new Satellite[]{phobos, deimos});
        sol.setSatellites(new Satellite[]{mercury, venus, earth, mars});

        printSummary(sol);
    }

    /**
     * Prints a summary for the star's solar system.
     *
     * @param star the star to be examined
     */
    public static void printSummary(CelestialBody star) {
        System.out.println("Summary for " + star.getName() + ":");
        System.out.printf("Surface Gravity: %1$e m/s\n\n",
                star.getSurfaceGravity());

        for (Satellite satellite : star.getSatellites()) {
            satellite.printSummary();
        }
    }
}
