#include "calc.h"

Calc::Calc() : _currentTotal(0.0), _startNumber(true), _displayField("0"), _previousOp("=")
{
    _error = tr("ERROR");  // need to be in the context of a QObject it seems to use tr
}

QString Calc::displayField() const {
    return _displayField;
}

void Calc::setDisplayField(QString displayField) {
    if (_displayField != displayField) {
        _displayField = displayField;
        emit displayFieldChanged();
    }
}


double Calc::getTotal() const {
    return _currentTotal;
}

void Calc::setTotal(QString total) {
    _currentTotal = total.toDouble();
}

void Calc::add(QString n) {
    _currentTotal += n.toDouble();
}

void Calc::subtract(QString n) {
    _currentTotal -= n.toDouble();
}

void Calc::multiply(QString n) {
    _currentTotal *= n.toDouble();
}

void Calc::divide(QString n) {
    // check for zero
    _currentTotal /= n.toDouble();
}

void Calc::clear() {
    _startNumber = true;
    setDisplayField("0");
    _previousOp = "=";
    setTotal("0");
}

void Calc::clearEntry() {
    _startNumber = true;
    setDisplayField("0");
}

void Calc::backspace() {
    if (_displayField.length() > 0)
        setDisplayField(_displayField.left(_displayField.length()-1));
}

void Calc::negate() {
    if (_displayField != _error) {
        if (_displayField.length() > 0) {
            if (_displayField[0] == '-')
                setDisplayField(_displayField.right(_displayField.length()-1));
            else
                setDisplayField("-" + _displayField);
            _startNumber = true;
        }
    }
}



void Calc::applyOp(QString op) {
    if (_startNumber) {
        clear();
        setDisplayField(_error);  // expecting a number
    } else {
        _startNumber = true;
        if (_previousOp == "=")
            setTotal(displayField());
        else if (_previousOp == "+")
            add(displayField());
        else if (_previousOp == "-")
            subtract(displayField());
        else if (_previousOp == "*")
            multiply(displayField());
        else if (_previousOp == "/")
            divide(displayField());

        setDisplayField(QString("%1").arg(getTotal()));
        _previousOp = op;
    }
}

void Calc::applyDigit(QString digit) {
    if (_startNumber) {
        // first digit - clear field and set
        setDisplayField(digit);
        _startNumber = false;
    } else
        // append digit
        setDisplayField(displayField() + digit);     // be sure to use set so onChanged called
}
