import QtQuick 2.6
import QtQuick.Window 2.2
import QtQuick.Controls 2.1
import QtQuick.Layouts 1.3

Window {
    visible: true
    width: 640
    height: 480
    title: qsTr("Calculator")


    ColumnLayout {
        anchors.fill: parent

        TextEdit {
            id: textEdit
            text: calc.displayField
            verticalAlignment: Text.AlignVCenter
            horizontalAlignment: Text.AlignRight
            anchors.left: parent.left
            anchors.right: parent.right

            color: "#000000"
            font.family: "Abel"
            font.pointSize: 16
            anchors.margins: 10

            Rectangle {
                anchors.fill: parent
                color: "transparent"
                border.width: 1
            }
        }



        GridLayout {
            id: grid
            rows: 4
            columns: 4
            anchors.left: parent.left
            anchors.right: parent.right

            GridButton {
                text: "CE"
                onClicked: calc.clearEntry()
            }

            GridButton {
                text: "C"
                onClicked: calc.clear()
            }
            GridButton {
                text: "\u2190" // "<-"
                onClicked: calc.backspace()
            }
            GridButton {
                text: "/"
                onClicked: calc.applyOp("/")
            }

            GridButton {
                text: "7"
                onClicked: calc.applyDigit("7")
            }
            GridButton {
                text: "8"
                onClicked: calc.applyDigit("8")
            }
            GridButton {
                text: "9"
                onClicked: calc.applyDigit("9")
            }
            GridButton {
                text: "*"
                onClicked: calc.applyOp("*")
            }

            GridButton {
                text: "4"
                onClicked: calc.applyDigit("4")
            }
            GridButton {
                text: "5"
                onClicked: calc.applyDigit("5")
            }
            GridButton {
                text: "6"
                onClicked: calc.applyDigit("6")
            }
            GridButton {
                text: "-"
                onClicked: calc.applyOp("-")
            }

            GridButton {
                text: "1"
                onClicked: calc.applyDigit("1")
            }
            GridButton {
                text: "2"
                onClicked: calc.applyDigit("2")
            }
            GridButton {
                text: "3"
                onClicked: calc.applyDigit("3")
            }
            GridButton {
                text: "+"
                onClicked: calc.applyOp("+")
            }

            GridButton {
                text: "\u00B1" // "+/-"
                onClicked: calc.negate()
            }

            GridButton {
                text: "0"
                onClicked: calc.applyDigit("0")
            }
            GridButton {
                text: "."
                onClicked: calc.applyDigit(".")
            }
            GridButton {
                text: "="
                onClicked: calc.applyOp("=")
            }

        }


    }
}
