#ifndef CALC_H
#define CALC_H

#include <QObject>
#include <QQmlApplicationEngine>
#include <QString>

class Calc : public QObject
{
    Q_OBJECT

    Q_PROPERTY(QString displayField READ displayField WRITE setDisplayField NOTIFY displayFieldChanged)

    double _currentTotal;
    bool _startNumber;
    QString _displayField;
    QString _previousOp;
    QString _error;

public:
    Calc();

    QString displayField() const;
    void setDisplayField(QString displayField);

    void add(QString n);
    void subtract(QString n);
    void multiply(QString n);
    void divide(QString n);

    Q_INVOKABLE double getTotal() const;
    Q_INVOKABLE void setTotal(QString total);
    Q_INVOKABLE void clear();
    Q_INVOKABLE void clearEntry();
    Q_INVOKABLE void backspace();
    Q_INVOKABLE void applyOp(QString op);
    Q_INVOKABLE void negate();
    Q_INVOKABLE void applyDigit(QString digit);

signals:
    void displayFieldChanged();
};

#endif // CALC_H
