// Copyright (c) 2010, Object Computing, Inc.
// All rights reserved.

#include "Profiler.h"
#include <iostream>
#include <iomanip>
#include <cmath>
#include <math.h>

namespace MiddlewareNewsBrief {

ProfileAccumulator * ProfileAccumulator::root_ = 0;
MIDDLEWARENEWSBRIEF_PROFILER_TIME_TYPE ProfileAccumulator::firstStart_ = 0;
MIDDLEWARENEWSBRIEF_PROFILER_TIME_TYPE ProfileAccumulator::lastEnd_ = 0;

ProfileAccumulator::ProfileAccumulator(const char * name, const char * file, size_t line)
  : name_(name)
  , file_(file)
  , line_(line)
  , entries_(0)
  , exits_(0)
  , pauses_(0)
  , resumes_(0)
  , sum_(0)
  , sumOfSquares_(0)
  , recursions_(0)
  , recursiveSum_(0)
  , recursiveSumOfSquares_(0)

{
  next_ = root_;
  root_ = this;
}

void
ProfileAccumulator::write(std::ostream & out)
{
  const ProfileAccumulator * ac = root_;
  out << "name\t\t\t\tfile\tline\tentries\texits\tsum\tsum_of_squares"
    << "\trecursions\trecursive_sum\trecursive_sum_of_squares"
    // helpers
    << "\tnonRsum"
    << "\tnonRmean"
    << std::endl;
  while(ac != 0)
  {
    out << ac->name_
      << '\t' << ac->file_
      << '\t' << ac->line_
      << '\t' << ac->entries_
      << '\t' << ac->exits_
      << '\t' << ac->sum_
      << '\t' << ac->sumOfSquares_
      << '\t' << ac->recursions_
      << '\t' << ac->recursiveSum_
      << '\t' << ac->recursiveSumOfSquares_
      // helpers
      << '\t' << ac->sum_ - ac->recursiveSum_
      << '\t' << double(ac->sum_ - ac->recursiveSum_) /double(ac->exits_ - ac->recursions_)
      << std::endl;
    ac = ac->next_;
  }
}

void
ProfileAccumulator::print(std::ostream & out)
{
  const ProfileAccumulator * ac = root_;
  
  out << "Elapsed time from first start time to last end time: " 
      << (lastEnd_ - firstStart_) << std::endl;

  out << "name\tcount\tsum\tmean\tstd_dev\tjitter\tmax\trecursions\trsum\trmean\trstd_dev" << std::endl;
  while(ac != 0)
  {
    double count = double(ac->exits_ - ac->recursions_);
    double sum = double(ac->sum_ - ac->recursiveSum_);
    double sumsq = double(ac->sumOfSquares_ - ac->recursiveSumOfSquares_);
    double total_jitter = double(ac->total_jitter_);

    out << ac->name_
      << '\t' << std::fixed << std::setprecision(0) << count
      << '\t' << std::fixed << std::setprecision(0) << sum;
    if(count > 1)
    {
      double mean = sum/ count;
      double stdDev = std::sqrt((sumsq - sum * mean) / (count - 1.0));
      double jitter = total_jitter/count;
      out
        << '\t' << std::fixed << std::setprecision(3) << mean
        << '\t' << std::fixed << std::setprecision(3) << stdDev
        << '\t' << std::fixed << std::setprecision(3) << jitter
        << '\t' << std::fixed << std::setprecision(3) << ac->max_
        << '\t' << ac->recursions_;
      if(ac->recursions_ > 0)
      {
        double count = double(ac->recursions_);
        double sum = double(ac->recursiveSum_);
        double sumsq = double(ac->recursiveSumOfSquares_);
        double mean = sum/ count;
        double stdDev = std::sqrt((sumsq - sum * mean) / (count - 1.0));
        out << '\t' << std::fixed << std::setprecision(0) << sum
          << '\t' << std::fixed << std::setprecision(3) << mean
          << '\t' << std::fixed << std::setprecision(3) << stdDev;
      }
    }
    out << std::endl;
    ac = ac->next_;
  }
}

} // MiddlewareNewsBrief
