// -*- C++ -*-
//
// $Id: DataReader_T.h,v 1.1 2006/03/31 16:53:17 don Exp $
//
// Copyright (c) 2010, Object Computing, Inc.
// All rights reserved.
//
#ifdef _MSC_VER
# pragma once
#endif
#ifndef MIDDLEWARENEWSBRIEF_DDSUTIL_DATAREADER_T_H
#define MIDDLEWARENEWSBRIEF_DDSUTIL_DATAREADER_T_H

#include "DDSUtil.h"
#include "EchoWriter_T.h"
#include "DDSTypeDetails_T.h"
#include <string>

// OpenDDS
#include <dds/DdsDcpsSubscriptionS.h>
#include <dds/DCPS/Service_Participant.h>
#include <dds/DCPS/SubscriberImpl.h>
#include <dds/DCPS/PublisherImpl.h>

// Profiler
#include "Profiler.h"

#if !defined (ACE_LACKS_PRAGMA_ONCE)
#pragma once
#endif /* ACE_LACKS_PRAGMA_ONCE */

namespace MiddlewareNewsBrief {

template <typename DDS_STRUCT_T> 
class DataReader 
{
public:
  typedef DDSTypeDetails<DDS_STRUCT_T> Details;

  //Constructor
  DataReader ();
  virtual ~DataReader();

  void init(DDS::DomainParticipant_ptr participant,
            DDS::Publisher_ptr publisher,
            DDS::Subscriber_ptr subscriber,
            CORBA::ULong DDS_STRUCT_T::* timestampField = 0,
            DDS_STRUCT_T instancePrototype = DDS_STRUCT_T(),
            std::string topic_name = "");

  void do_echo(size_t sleepUsecBetweenWrites = 0);

private:
  EchoWriter<DDS_STRUCT_T> echo_writer_;
};

template <typename DDS_STRUCT_T>
DataReader<DDS_STRUCT_T>::DataReader()
{
}

template <typename DDS_STRUCT_T>
DataReader<DDS_STRUCT_T>::~DataReader()
{
}

template <typename DDS_STRUCT_T>
void
DataReader<DDS_STRUCT_T>::init(
  DDS::DomainParticipant_ptr participant,
  DDS::Publisher_ptr publisher,
  DDS::Subscriber_ptr subscriber,
  CORBA::ULong DDS_STRUCT_T::* timestampField,
  DDS_STRUCT_T instancePrototype,
  std::string topic_name)
{
  // Create a DataWriter for the topic
  DDS::DataReader_var dr =
    DDSUtil::create_datareader<typename Details::TypeSupportImpl>(participant,
                                                                  subscriber,
                                                                  topic_name,
                                                                  0);
  
  this->echo_writer_.init(participant,
                          publisher,
                          dr.in(),
                          timestampField,
                          instancePrototype);
}

template <typename DDS_STRUCT_T>
void
DataReader<DDS_STRUCT_T>::do_echo(size_t sleepUsecBetweenWrites)
{
  this->echo_writer_.do_echo(sleepUsecBetweenWrites);
}

} // MiddlewareNewsBrief

#endif /* MIDDLEWARENEWSBRIEF_DSUTIL_DATAREADER_T_H */
