// Copyright (c) 2010, Object Computing, Inc.
// All rights reserved.

#ifdef _MSC_VER
# pragma warning(disable:4005) // Disable VC warning about duplicate macros;
                               // Boost and ACE define same macros for Windows
#endif

#include "OpenDdsPubSubUtil.h"

// DdsUtil
#include <DataWriter_T.h>
//#include <DoneTokenManager.h>

// OpenDDS
#include <dds/DCPS/transport/framework/TheTransportFactory.h>
#include <dds/DCPS/Service_Participant.h>
#include <dds/DCPS/Marked_Default_Qos.h>
#include <dds/DCPS/PublisherImpl.h>

#include <iostream>
#include <stdexcept>

// .NET
#include <vcclr.h>
using namespace System;
using namespace System::Runtime::InteropServices;

MiddlewareNewsBrief::OpenDdsPubSubUtil::OpenDdsPubSubUtil(
  int argc, 
  char** argv,
  gcroot<OpenDdsPubSubProxy^> managed_parent,
  ProcessType ptype)
  : managed_parent_(managed_parent)
  , PRIMARY_PARTITION("Primary")
  , SECONDARY_PARTITION("Secondary")
{
  //
  // OpenDDS Init
  //
  
  // Initialize, and create a DomainParticipantFactory
  this->factory_ = TheParticipantFactoryWithArgs(argc, argv);
  
  //  Create the DomainParticipant
  const int DOMAIN_ID = 8675309;
  this->participant_ = 
    this->factory_->create_participant(DOMAIN_ID,
                                       PARTICIPANT_QOS_DEFAULT,
                                       0,
                                       0);
  if (this->participant_ == 0)  
  {
    throw std::runtime_error("create_participant failed");
  }
  
  if (ptype == ProcessType::PUBLISHER_PROCESS)
  {
    this->ctor_publisher();
  }
  else // (ptype == ProcessType::SUBSCRIBING_PROCESS)
  { 
    this->ctor_subscriber();
  }
}

void
MiddlewareNewsBrief::OpenDdsPubSubUtil::ctor_publisher()
{
  // Create a publisher for the topics
  const int PUB_TRANSPORT_IMPL_ID = 1;
  this->publisher_ = 
    MiddlewareNewsBrief::DDSUtil::create_publisher(this->participant_.in(),
                                                   PUB_TRANSPORT_IMPL_ID,
                                                   PRIMARY_PARTITION.c_str());
  
  // Create a subscriber for the Echo of the two topics
  const int SUB_TRANSPORT_IMPL_ID = 2;
  this->subscriber_ = 
    MiddlewareNewsBrief::DDSUtil::create_subscriber(this->participant_.in(),
                                                    SUB_TRANSPORT_IMPL_ID,
                                                    SECONDARY_PARTITION.c_str());
  
  // Initialize the DoneToken manager, which publishes a "done" token
  this->doneToken_.initWriter(this->participant_,
                              this->publisher_,
                              this->subscriber_);
}


void
MiddlewareNewsBrief::OpenDdsPubSubUtil::ctor_subscriber()
{
  // Create a publisher for the topics
  const int PUB_TRANSPORT_IMPL_ID = 2;
  this->publisher_ = 
    MiddlewareNewsBrief::DDSUtil::create_publisher(this->participant_.in(),
                                                   PUB_TRANSPORT_IMPL_ID,
                                                   SECONDARY_PARTITION.c_str());
  
  // Create a subscriber for the Echo of the two topics
  const int SUB_TRANSPORT_IMPL_ID = 1;
  this->subscriber_ = 
    MiddlewareNewsBrief::DDSUtil::create_subscriber(this->participant_.in(),
                                                    SUB_TRANSPORT_IMPL_ID,
                                                    PRIMARY_PARTITION.c_str());
  
  // Initialize the DoneToken manager, which publishes a "done" token
  this->doneToken_.initReader(this->participant_,
                              this->publisher_,
                              this->subscriber_);
}

MiddlewareNewsBrief::OpenDdsPubSubUtil::~OpenDdsPubSubUtil() 
{
  try {
    this->fini();
  }
  catch (std::exception & e)
  {
    std::cerr << "Exception in ~OpenDdsPubSubUtil: " << e.what() << std::endl;
  }
  catch (CORBA::Exception& e) 
  {
    std::cerr << "Exception in ~OpenDdsPubSubUtil: " << e << std::endl;
  }
  catch (...) 
  {
    std::cerr << "Unknown Exception in ~OpenDdsPubSubUtil" << std::endl;
  }
}

int
MiddlewareNewsBrief::OpenDdsPubSubUtil::create_datawriter(char* topic_name)
{
  //
  // DataWriter
  //  
  DDS::DataWriter_var dw =
    DDSUtil::create_datawriter<MiddlewareNewsBrief::RawBufferTypeSupportImpl>(
      this->participant_,
      this->publisher_,
      topic_name);
  MiddlewareNewsBrief::RawBufferDataWriter_var writer = 
    MiddlewareNewsBrief::RawBufferDataWriter::_narrow(dw.in());
  if (writer == 0) 
  {
    throw std::runtime_error("RawBufferDataWriter::_narrow failed");
  }
  
  MiddlewareNewsBrief::RawBuffer instancePrototype;
  DDS::InstanceHandle_t instance_handle = 
    writer->register_instance(instancePrototype);

  //
  // DataReader for echoed samples
  //
  DDS::DataReader_var dr =
    DDSUtil::create_datareader<MiddlewareNewsBrief::RawBufferTypeSupportImpl>(
      this->participant_,
      this->subscriber_,
      topic_name,
      this);
  if (dr == 0) 
  {
    throw std::runtime_error("create RawBufferDataReader failed");
  }

  int retval_handle = this->writers_.size();
  Writer w;
  w.writer_ = writer;
  w.instance_handle_ = instance_handle;
  this->writers_.push_back(w);
  this->topicToWriterHandle_[topic_name] = retval_handle;

  return retval_handle;
}


void
MiddlewareNewsBrief::OpenDdsPubSubUtil::write(
  int data_writer_handle,
  MiddlewareNewsBrief::BufferType& buffer)
{
  this->payload_.buffer = buffer;

  Writer& w = this->writers_[data_writer_handle];
  w.writer_->write(this->payload_,w.instance_handle_);
}


void
MiddlewareNewsBrief::OpenDdsPubSubUtil::write_done()
{
  this->doneToken_.writeDone("Done");
}


bool
MiddlewareNewsBrief::OpenDdsPubSubUtil::is_done() const
{
  return this->doneToken_.isDone();
}

void
MiddlewareNewsBrief::OpenDdsPubSubUtil::fini()
{
  if (this->publisher_ != 0)
  {
    // Give the samples time to make it to the subscribers
    DDS::Duration_t duration;
    duration.sec = DDS::DURATION_INFINITE_SEC;
    duration.nanosec = DDS::DURATION_INFINITE_NSEC;
    this->publisher_->wait_for_acknowledgments(duration);
  }

  // OpenDDS Cleanup
  if (this->subscriber_ != 0) 
  {
    this->subscriber_->delete_contained_entities();
    this->participant_->delete_subscriber(this->subscriber_.in());
    this->subscriber_ = DDS::Subscriber::_nil();
  }
  if (this->publisher_ != 0) 
  {
    this->doneToken_.fini(this->publisher_.in());
    this->publisher_->delete_contained_entities();
    this->participant_->delete_publisher(this->publisher_.in());
    this->publisher_ = DDS::Publisher::_nil();
  }
  if (this->participant_ != 0) 
  {
    this->participant_->delete_contained_entities();
  }
  if (this->factory_ != 0) 
  {
    this->factory_->delete_participant(this->participant_.in ());
    this->participant_ = DDS::DomainParticipant::_nil();
  }
  TheTransportFactory->release();
  TheServiceParticipant->shutdown();  
}

void 
MiddlewareNewsBrief::OpenDdsPubSubUtil::on_data_available(
  DDS::DataReader_ptr reader)
  throw (CORBA::SystemException)
{
  MiddlewareNewsBrief::RawBufferDataReader_var dr = 
    MiddlewareNewsBrief::RawBufferDataReader::_narrow(reader);
  if (dr == 0) 
  {
    std::cerr << "MiddlewareNewsBrief::OpenDdsPubSubUtil::on_data_available: _narrow failed." 
              << std::endl;
    return;
  }

  // Take a sample

  MiddlewareNewsBrief::RawBuffer sample;
  DDS::SampleInfo si ;
  DDS::ReturnCode_t status = dr->take_next_sample(sample, si);

  while (status == DDS::RETCODE_OK) 
  {
    if (si.instance_state == DDS::ALIVE_INSTANCE_STATE)
    {
      DDS::TopicDescription_var td = reader->get_topicdescription();
      CORBA::String_var topic_name = td->get_name();
      int data_writer_handle = this->topicToWriterHandle_[topic_name.in()];

      // Have to copy to pass the sample's octet buffer up to the .NET layer
      array<unsigned char> ^managed_buffer = gcnew array<unsigned char>(sample.buffer.length());
      Marshal::Copy((IntPtr)sample.buffer.get_buffer(), managed_buffer, 0, sample.buffer.length());
      //for (size_t i = 0; i < sample.buffer.length(); ++i) {
      //  managed_buffer[i] = sample.buffer[i];
      //}

      this->managed_parent_->ProcessNotification(
  			this->managed_parent_,
        data_writer_handle,
        managed_buffer);
    }

    // See if there's another one
    status = dr->take_next_sample(sample, si);
  } 
}


// To eliminate a bogus linker warning
namespace CORBA { 
	class InterfaceDef {};
	class Context {};
	class NVList {};
	class NamedValue {};
	class Request {};
	class ExceptionList {};
	class ContextList {};
}

