// Copyright (c) 2010, Object Computing, Inc.
// All rights reserved.

#include "zmq.hpp"
#include <iostream>

int main (int argc, char *argv [])
{
  try {
    if (argc != 5) {
      std::cout << "usage: ZeromqSubscriber <message-size> <roundtrip-count> <bind-to-sub> <connect-to-pub>\n"
                << "e.g.:  ZeromqSubscriber 1000 10000 tcp://eth0:54322 tcp://spider:54321\n"
                << "          on Windows, use a literal IP address and port for each endpoint\n"
                << std::endl;
        return 1;
    }
    size_t message_size = atoi (argv [1]);
    size_t roundtrip_count = atoi (argv [2]);
    const char* bind_to_sub = argv [3];
    const char* connect_to_pub = argv [4];

    zmq::context_t ctx (1, 1);
    zmq::socket_t pub (ctx, ZMQ_PUB);
    pub.connect(connect_to_pub);

    zmq::socket_t sub (ctx, ZMQ_SUB);
    sub.setsockopt(ZMQ_SUBSCRIBE,"DataFeed\x00",9);
    sub.bind(bind_to_sub);

    printf("Entering recv loop -- %d messages, size = %d\n", 
           roundtrip_count,
           message_size);

    for (size_t i = 0; i != roundtrip_count; i++) {
      zmq::message_t msg;
      sub.recv (&msg);

      // Echo it back
      pub.send(msg,0);
    }
    printf("Finished receiving messages\n");
    
    return 0;

  } catch (std::exception &e) {
    std::cout << "An error occurred: " << e.what() << std::endl;
    return 1;
  }
}
