﻿
using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.InteropServices;
using System.Diagnostics;

class ZmqDotnetSubscriber
{
    static unsafe int Main(string[] args)
    {
        if (args.Length != 4)
        {
           Console.Out.WriteLine("usage: ZmqDotnetSubscriber <message-size> <roundtrip-count> " +
                "<bind-to-sub> <connect-to-pub>\n");
           Console.Out.WriteLine(" e.g.: ZmqDotnetSubscriber 1000 10000 tcp://10.201.200.72:54322 tcp://10.201.200.72:54321\n");
           return 1;
        }

        uint messageSize = Convert.ToUInt32(args[0]);
        int roundtripCount = Convert.ToInt32(args[1]);
        String bind_to_sub = args[2];
        String connect_to_pub = args[3];

        //  Initialise 0MQ infrastructure
        ZMQ.Context ctx = new ZMQ.Context(1, 1, 0);
        
        ZMQ.Socket pub = ctx.Socket(ZMQ.PUB);
        pub.Connect(connect_to_pub);

        ZMQ.Socket sub = ctx.Socket(ZMQ.SUB);
        sub.SetSockOpt(ZMQ.SUBSCRIBE, "DataFeed");
        sub.Bind(bind_to_sub);

        Console.Out.WriteLine("Entering recv loop -- " + roundtripCount
           + " messages, size = " + messageSize);
        for (int i = 0; i < roundtripCount; i++)
        {
            byte[] msg;
            sub.Recv(out msg);

            // Echo it back
            pub.Send(msg);   
        }
        Console.Out.WriteLine("Finished receiving messages");

        return 0;
    }
}
